/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: Benjamin Grauer
*/

/*! 
  \file factory.h
  \brief philosophy stuff
*/


#ifndef _FACTORY_H
#define _FACTORY_H

class BaseObject;

#include "tinyxml.h"
#include "load_param.h"
#include "debug.h"

/** 
    Creates a factory to a Loadable Class.
    this should be used at the beginning of all the Classes that should be loadable (in the cc-file)
*/
#define CREATE_FACTORY(CLASS_NAME) tFactory<CLASS_NAME>* global_##CLASS_NAME##Factory = new tFactory<CLASS_NAME>(#CLASS_NAME); \
        CREATE_LOAD_DOC(CLASS_NAME)


		
//! The Factory is
class Factory {

 public:
  Factory (const char* name = NULL);
  ~Factory ();
  

  virtual BaseObject* fabricate(const TiXmlElement* root);
  void initialize();
  void registerFactory( Factory* factory);
  void setFactoryName(const char* name);
  const char* getFactoryName() {return factoryName;};
  void setNext( Factory* factory) {next = factory;}
  Factory* getNext() {return next;}
	
 private:
  char* factoryName;
	
  Factory* next;
};

template<class T> class tFactory : public Factory
{
 public:
  tFactory(const char* name);
  virtual ~tFactory();
  
  private:
  BaseObject* fabricate(const TiXmlElement* root);
};

template<class T>
tFactory<T>::tFactory(const char* name) : Factory(name)
{
  PRINTF(5)("fileName: %s\n", name);
}
  

template<class T>
tFactory<T>::~tFactory()
{}

template<class T>
BaseObject* tFactory<T>::fabricate(const TiXmlElement* root) 
{ 
  if(!strcmp(root->Value(), getFactoryName()))
    return new T ( root);
  else if( getNext() != NULL) 
    return getNext()->fabricate( root);
  else 
    return NULL;
}

// helper function

const char* grabParameter(const TiXmlElement* root, const char* name);

#endif /* _FACTORY_H */

