/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: Benjamin Grauer
*/


#include "factory.h"
#include "game_loader.h"

using namespace std;

/*  --------------------------------------------------
 *		 Factory
 *   --------------------------------------------------
 */

/**
   \brief constructor
   
   set everything to zero and define factoryName
*/
Factory::Factory (const char* name)
{
  this->factoryName = NULL;
  this->setFactoryName(name);
  next = NULL;
  
  initialize();
}

/**
   \brief destructor
   
   clear the Q
*/
Factory::~Factory ()
{
  //  printf("%s\n", this->factoryName);
  //  Factory* tmpDel = this->next;
  //  this->next = NULL;
  if (this->next)
    delete this->next;
}

void Factory::setFactoryName(const char* name)
{
  if (factoryName)
    delete factoryName;
  factoryName = new char[strlen(name)+1];
  strcpy(factoryName, name);
}


/**
   \brief generates the associated object from data
*/
BaseObject* Factory::fabricate(const TiXmlElement* data)
{
  return NULL;
}

/**
   \brief make this particular factory known to the LevelFactory
*/
void Factory::initialize()
{
  GameLoader* gl = GameLoader::getInstance();
  gl->registerFactory( this);
}

/**
   \brief add a Factory to the Q
*/
void Factory::registerFactory( Factory* factory)
{
  if( next == NULL) setNext( factory);
  else next->registerFactory( factory);
}

const char* grabParameter(const TiXmlElement* root, const char* name)
{
  const TiXmlElement* element;
  const TiXmlNode* node;
	
  assert( root != NULL);
  assert( name != NULL);
	
  element = root->FirstChildElement( name);
  if( element == NULL) return NULL;
	
  node = element->FirstChild();
  while( node != NULL)
    {
      if( node->ToText()) return node->Value();
      node = node->NextSibling();
    }
  return NULL;
}

