/*! 
    \file glmenu_imagescreen
    \brief class to display a image
*/


#ifndef _GLMENU_IMAGESCREEN_H
#define _GLMENU_IMAGESCREEN_H

#include "base_object.h"

class Material;
class TiXmlElement;

class GLMenuImageScreen : public BaseObject {

 public:
  GLMenuImageScreen ();
  GLMenuImageScreen (const TiXmlElement* root);
  void loadParams(const TiXmlElement* root);
  virtual ~GLMenuImageScreen ();

  void init ();

  void draw ();
  
  void setBackgroundImage(const char* backImageName);
  void setPosition(float offsetX, float offsetY);
  void setScale (float scaleX, float scaleY);
  void setPosScale(float offsetX, float offsetY, float scaleX, float scaleY);

  void setBarImage(const char* barImage);
  void setBarPosScale(float barX, float barY, float barW, float barH);

  void setMaximum (int maxValue);
  int getMaximum ();
  void setValue (int currentValue);
  int getValue ();
  void step ();

 private:
  char* backImageName;       //!< the name of the file of the background image
  float scaleX, scaleY;      //!< hight and width of the image
  float offsetX, offsetY;    //!< offset of the image from left and up
  Material* backMat;         //!< Background Material.
  float barX, barY, barW, barH; //!< Position and Scale of the bar.
  Material* barMat;          //!< A Material for the Loading-Bar

  /* progress bar values */
  int currentValue;          //!< the current count of step() calls fired yet
  int maxValue;              //!< total count of steps

};

#endif /* _GLMENU_IMAGESCREEN_H */
