

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "test_entity.h"
#include "stdincl.h"
#include "model.h"
#include "md2Model.h"

using namespace std;



TestEntity::TestEntity () : WorldEntity()
{  
  this->md2Model = new MD2Model();

  MD2Model2* model2 = new MD2Model2();
  model2->loadModel("../data/models/tris.md2");

  this->material = new Material("Clown");
  this->material->setDiffuseMap("../data/models/tris.pcx");
  this->material->setIllum(3);
  this->material->setAmbient(1.0, 1.0, 1.0);
}


TestEntity::~TestEntity () 
{}


void TestEntity::tick (float time) 
{
  this->md2Model->tick(time);
}


void TestEntity::hit (WorldEntity* weapon, Vector* loc) {}


void TestEntity::destroy () {}


void TestEntity::collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags) {}


void TestEntity::draw () 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];
  
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
   this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  

  /* TESTGING TESTING TESTING */
  this->material->select();
  //this->md2Model->draw(this->model);
  this->md2Model->animate();

  glPopMatrix();
}

