/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: 
*/

/*! 
    \file abstract_model.h
    \brief Definition of an abstract model. containing all needed for other model
*/

#ifndef _ABSTRACT_MODEL_H
#define _ABSTRACT_MODEL_H

#include "stdincl.h"
#include "base_object.h"
#include <vector>
#include <math.h>

using namespace std;

//template<class T> class tList;
;

//! This is our 3D point class.  CONFLICTING with Vector.cc
class CVector3 
{
public:
	float x, y, z;
};

//! This is our 2D point class.  CONFLICTING with Vector.cc
class CVector2 
{
public:
	float x, y;
};

// CONFLICTING with model.h
struct tFace
{
	int vertIndex[3];			// indicies for the verts that make up this triangle
	int coordIndex[3];			// indicies for the tex coords to texture this face
};

// CONFLICTING with material.cc, there are some small differences, i will use this struct and switch over later
struct tMaterialInfo
{
	char  strName[255];			// The texture name
	char  strFile[255];			// The texture file name (If this is set it's a texture map)
	byte  color[3];	// The color of the object (R, G, B)
	int   texureId;				// the texture ID
	float uTile;				// u tiling of texture  
	float vTile;				// v tiling of texture	
	float uOffset;			    // u offset of texture
	float vOffset;				// v offset of texture
} ;

//! properties of a 3D object
struct t3DObject 
{
	int  numOfVerts;			// The number of verts in the model
	int  numOfFaces;			// The number of faces in the model
	int  numTexVertex;			// The number of texture coordinates
	int  materialID;			// The texture ID to use, which is the index into our texture array
	bool bHasTexture;			// This is TRUE if there is a texture map for this object
	char strName[255];			// The name of the object
	CVector3  *pVerts;			// The object's vertices
	CVector3  *pNormals;		// The object's normals
	CVector2  *pTexVerts;		// The texture's UV coordinates
	tFace *pFaces;				// The faces information of the object
};

// CONFLICTING with animation.cc
struct tAnimationInfo
{
	char strName[255];			// This stores the name of the animation (Jump, Pain, etc..)
	int startFrame;				// This stores the first frame number for this animation
	int endFrame;				// This stores the last frame number for this animation
};

// CONFLICTING with animation.cc and vector.cc
struct t3DModel 
{
	int numOfObjects;					// The number of objects in the model
	int numOfMaterials;					// The number of materials for the model
	int numOfAnimations;				// The number of animations in this model (NEW)
	int currentAnim;					// The current index into pAnimations list (NEW)
	int currentFrame;					// The current frame of the current animation (NEW)
	vector<tAnimationInfo> animationList; // The list of animations (NEW)
	vector<tMaterialInfo> materialList;	// The list of material information (Textures and colors)
	vector<t3DObject> objectList;			// The object list for our model
};



//! This class defines the basic components of a model
class AbstractModel : public BaseObject {

 public:
  AbstractModel() {}
  virtual ~AbstractModel() {}
};


/* TESTING TESTING TESTING */
/* some mathematical functions that are already implemented by vector.cc class */

// magnitude of a normal
#define Mag(Normal) (sqrt(Normal.x*Normal.x + Normal.y*Normal.y + Normal.z*Normal.z))

class MathHelp {

 public:
  // vector between two points
  static CVector3 VectorDiff(CVector3 vPoint1, CVector3 vPoint2)
    {
      CVector3 vVector;							

      vVector.x = vPoint1.x - vPoint2.x;			
      vVector.y = vPoint1.y - vPoint2.y;			
      vVector.z = vPoint1.z - vPoint2.z;			

      return vVector;								
    }

  // adding vectors, returning result
  static CVector3 AddVector(CVector3 vVector1, CVector3 vVector2)
    {
      CVector3 vResult;							
	
      vResult.x = vVector2.x + vVector1.x;		
      vResult.y = vVector2.y + vVector1.y;		
      vResult.z = vVector2.z + vVector1.z;		

      return vResult;
    }

  // This divides a vector by a single number (scalar) and returns the result
  static CVector3 DivideVectorByScaler(CVector3 vVector1, float Scaler)
    {
      CVector3 vResult;							
	
      vResult.x = vVector1.x / Scaler;			
      vResult.y = vVector1.y / Scaler;		
      vResult.z = vVector1.z / Scaler;

      return vResult;	
    }

  // cross product between 2 vectors
  static CVector3 CrossProduct(CVector3 vVector1, CVector3 vVector2)
    {
      CVector3 vCross;	
      vCross.x = ((vVector1.y * vVector2.z) - (vVector1.z * vVector2.y));
      vCross.y = ((vVector1.z * vVector2.x) - (vVector1.x * vVector2.z));
      vCross.z = ((vVector1.x * vVector2.y) - (vVector1.y * vVector2.x));
      return vCross;	
    }

  // calculate the normal of a vector
  static CVector3 NormalizeVector(CVector3 vNormal)
    {
      double Magnitude;
      Magnitude = Mag(vNormal);	
      vNormal.x /= (float)Magnitude;	
      vNormal.y /= (float)Magnitude;	
      vNormal.z /= (float)Magnitude;	

      return vNormal;	
    }
};

#endif /* _ABSTRACT_MODEL_H */
