/*!
  \file globals.h
  \brief This file defines some default values.
  
  no Class is defined here.
*/

#ifndef _GLOBALS_H
#define _GLOBALS_H

#define ORXONOX_STAFF "Patrick Boenzli - Captain\n" \
                      "Benjamin Grauer - First Officer\n" \
		      "Christian Meyer - Engeneer\n" \
		      "Nico Bernold - Physics\n" \
		      "David Gruetter - The ProtoType\n" \
		      "many more\n" 

#define DEFAULT_CONFIG_FILE "~/.orxonox/orxonox.conf"
#define DEFAULT_DATA_DIR "/usr/share/orxonox/data/"
#define DEFAULT_DATA_DIR_CHECKFILE "data.oxd"

// Defines all the Sections of the Config (in Gui and ORxonox)
//! Name of Section Misc in the config-File
#define CONFIG_SECTION_MISC "misc"
#define CONFIG_SECTION_MISC_KEYS "miscKeys"
#define CONFIG_SECTION_PLAYER "player"
#define CONFIG_SECTION_VIDEO "video"
#define CONFIG_SECTION_VIDEO_ADVANCED "video_advanced"
#define CONFIG_SECTION_AUDIO "audio"
#define CONFIG_SECTION_EXEC "exec"
#define CONFIG_SECTION_DATA "data"

/*
  TAGS for all the Configuration Options
  Consider they may __not__ have any WhiteSpaces inside
*/
#define CONFIG_NAME_DATADIR "DataDir"
#define CONFIG_NAME_AUTO_UPDATE "Auto-Update"
#define CONFIG_NAME_FULLSCREEN "Fullscreen-mode"
#define CONFIG_NAME_RESOLUTION "Resolution"
#define CONFIG_NAME_WIREFRAME "WireFrame-mode"
#define CONFIG_NAME_SHADOWS "Shadows"
#define CONFIG_NAME_FOG "Fog"
#define CONFIG_NAME_REFLECTIONS "Reflections"
#define CONFIG_NAME_TEXTURES "TEXTURES"
#define CONFIG_NAME_TEXTURE_DETAIL "Texture-Detail"
#define CONFIG_NAME_MODEL_DETAIL "Model-Detail"
#define CONFIG_NAME_ANTI_ALIASING "Anti-Aliasing"
#define CONFIG_NAME_FILTER_METHOD "Filtering-Method"
#define CONFIG_NAME_DISABLE_AUDIO "Disable-Audio"
#define CONFIG_NAME_MUSIC_VOLUME "Music-Volume"
#define CONFIG_NAME_EFFECTS_VOLUME "Effects-Volume"
#define CONFIG_NAME_SAVE_SETTINGS "Save-Settings"
#define CONFIG_NAME_VERBOSE_MODE "Verbose-Mode"
#define CONFIG_NAME_ALWAYS_SHOW_GUI "Always-Show-The-Gui"
#define CONFIG_NAME_PLAYER_UP "Up"
#define CONFIG_NAME_PLAYER_DOWN "Down"
#define CONFIG_NAME_PLAYER_LEFT "Left"
#define CONFIG_NAME_PLAYER_RIGHT "Right"
#define CONFIG_NAME_PLAYER_FIRE "Fire"
#define CONFIG_NAME_PLAYER_NEXT_WEAPON "Next"
#define CONFIG_NAME_PLAYER_PREV_WEAPON "Prev"
#define CONFIG_NAME_QUIT "Quit"
#define CONFIG_NAME_PAUSE "Pause"
#define CONFIG_NAME_NEXT_WORLD "Next-World"
#define CONFIG_NAME_PREV_WORLD "Prev-World"
#define CONFIG_NAME_VIEW0 "view0"
#define CONFIG_NAME_VIEW1 "view1"
#define CONFIG_NAME_VIEW2 "view2"
#define CONFIG_NAME_VIEW3 "view3"
#define CONFIG_NAME_VIEW4 "view4"
#define CONFIG_NAME_VIEW5 "view5"


#endif /* _GLOBALS_H */
