#!/usr/bin/perl
########################################################################## 
#   orxonox - the future of 3D-vertical-scrollers			 #
#									 #
#   Copyright (C) 2004 orx						 #
#									 #
#   This program is free software; you can redistribute it and/or modify #
#   it under the terms of the GNU General Public License as published by #
#   the Free Software Foundation; either version 2, or (at your option)  #
#   any later version.							 #
#									 #
#   ### File Specific:							 #
#   main-programmer: Benjamin Grauer					 #
#   co-programmer: ...							 #
#									 #
#   This is a simple perl script, that generates a List of all files     #
#   contained in a Folder checked out with SVN and writes into an output #
#   file.                                                                #
##########################################################################

if (@ARGV[0] eq "-h" || $ARGV[0] eq "--help" || @ARGV != 2)
  {
    die ("usage: data.genlist.pl <data-directory> <output-file>\n");
  }


if (! -d @ARGV[0])
  {
    die ("@ARGV[0] is not regular Directory.\n");
  }

open(FD, "> @ARGV[1]") or die("Couldn't open @ARGV[1]\n") ;


&createFileList(@ARGV[0]);

close(FD);


sub createFileList
  {
   my ($folderName) = @_;
   my ($fullName);
   my ($inputFile);
   my ($printFile);
   my (@folderList);

   open(FOLDERLIST, "ls $folderName -1 |");
   @folderList = <FOLDERLIST>;

   foreach $inputFile (@folderList)
     {
       if ($inputFile eq "." || $inputFile eq "..")
	 {

	 }
       chomp($inputFile);
       $fullName = "$folderName/$inputFile";

       $printFile = $fullName;
       $printFile =~ s/@ARGV[0]//;
       print FD "$printFile\n";
       if (-d $fullName )
	 {
	   &createFileList($fullName);
	 }
     }
 }
