/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*! 
    \file debug.h
    \brief Handles output to console for different Verbose-Modes.

    There are two main modes HARD and SOFT. HARD is precessed during compileTime where SOFT is for runtime.
    \li HARD: One can choose between different modes. see: // DEFINE_MODULES 
    \li SOFT: If you want each module can have its own variable for processing. just pass it to DEBUG_MODULE_SOFT
*/ 

#ifndef _DEBUG_H
#define _DEBUG_H

#include "confincl.h"

#include <stdio.h>

// DEFINE ERROR MODES
#define NO              0
#define ERR             1
#define WARN            2
#define INFO            3
#define DEBUGING        4
#define vDEBUGING       5

extern int verbose;

//definitions
#ifndef MODULAR_DEBUG
#define HARD_DEBUG_LEVEL DEBUG
#define SOFT_DEBUG_LEVEL verbose
#else /* MODULAR_DEBUG */
#ifndef DEBUG_MODULE_SOFT 
#define SOFT_DEBUG_LEVEL verbose
#else /* DEBUG_MODULE_SOFT */
#define SOFT_DEBUG_LEVEL DEBUG_MODULE_SOFT
#endif /* DEBUG_MODULE_SOFT */

#ifndef DEBUG_SPECIAL_MODULE
#define HARD_DEBUG_LEVEL DEBUG
#else /* DEBUG_SPECIAL_MODULE */
// DEFINE MODULES
#define DEBUG_MODULE_ORXONOX            0
#define DEBUG_MODULE_WORLD              1
#define DEBUG_MODULE_PNODE              1
#define DEBUG_MODULE_WORLD_ENTITY       0
#define DEBUG_MODULE_COMMAND_NODE       4
#define DEBUG_MODULE_GRAPHICS           0
#define DEBUG_MODULE_LOAD               2

#define DEBUG_MODULE_IMPORTER           3
#define DEBUG_MODULE_TRACK_MANAGER      0
#define DEBUG_MODULE_GARBAGE_COLLECTOR  0
#define DEBUG_MODULE_LIGHT              0
#define DEBUG_MODULE_PLAYER             1
#define DEBUG_MODULE_WEAPON             3
#define DEBUG_MODULE_MATH               0
#define DEBUG_MODULE_FONT               1
#define DEBUG_MODULE_ANIM               1
#define DEBUG_MODULE_PARTICLE           4

#define DEBUG_MODULE_NULL_PARENT        0


#define HARD_DEBUG_LEVEL DEBUG_SPECIAL_MODULE
#endif /* DEBUG_SPECIAL_MODULE */
#endif /* MODULAR_DEBUG */
///////////////////////////////////////////////////
/// PRINTF: prints with filename and linenumber ///
///////////////////////////////////////////////////

#ifdef DEBUG

#define PRINTF(x) \
           PRINTF ## x

#if HARD_DEBUG_LEVEL >= ERR
#define PRINTF1 \
    if (SOFT_DEBUG_LEVEL >= ERR) \
      printf("ERROR::%s:%d:", __FILE__, __LINE__) && printf
#else 
#define PRINTF1 if (NO)
#endif
     
#if HARD_DEBUG_LEVEL >= WARN
#define PRINTF2 \
     if (SOFT_DEBUG_LEVEL >= WARN) \
       printf("WARNING::%s:%d:", __FILE__, __LINE__) && printf
         
#else 
#define PRINTF2 if (NO)
#endif
     
#if HARD_DEBUG_LEVEL >= INFO
#define PRINTF3 \
     if (SOFT_DEBUG_LEVEL >= INFO) \
       printf("INFO::%s:%d:", __FILE__, __LINE__) && printf
#else 
#define PRINTF3 if (NO)
#endif
     
#if HARD_DEBUG_LEVEL >= DEBUGING
#define PRINTF4 \
     if (SOFT_DEBUG_LEVEL >= DEBUGING) \
       printf("DEBUG::%s:%d:", __FILE__, __LINE__) && printf
#else 
#define PRINTF4 if (NO)
#endif
     
#if HARD_DEBUG_LEVEL >= vDEBUGING
#define PRINTF5 \
     if (SOFT_DEBUG_LEVEL >= vDEBUGING) \
       printf("VERYDEBUG::%s:%d:", __FILE__, __LINE__) && printf
#else 
#define PRINTF5 if (NO)
#endif
    
#else  
#define PRINTF(x) if (NO)
#endif

#define PRINTF0 \
    printf("%s:%d::", __FILE__, __LINE__) && printf


///////////////////////////////////////////////////
///  PRINT: just prints output as is            ///
///////////////////////////////////////////////////
#ifdef  DEBUG
#define PRINT(x) \
  PRINT ## x

#if HARD_DEBUG_LEVEL >= ERR
#define PRINT1	\
  if (SOFT_DEBUG_LEVEL >= ERR)	\
    printf
#else 
#define PRINT1 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= WARN
#define PRINT2 \
  if (SOFT_DEBUG_LEVEL >= WARN) \
    printf

#else 
#define PRINT2 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= INFO
#define PRINT3 \
  if (SOFT_DEBUG_LEVEL >= INFO) \
    printf
#else 
#define PRINT3 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= DEBUGING
#define PRINT4 \
  if (SOFT_DEBUG_LEVEL >= DEBUGING) \
    printf
#else 
#define PRINT4 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= vDEBUGING
#define PRINT5 \
     if (SOFT_DEBUG_LEVEL >= vDEBUGING) \
       printf("VERYDEBUG::%s:%d:", __FILE__, __LINE__) && printf
#else 
#define PRINT5 if (NO)
#endif


#else  
#define PRINT(x) if (NO)
#endif

#define PRINT0 \
  printf

///////////////////////////////////////////////////
/// COUT: simple cout print with verbose-check  ///
///////////////////////////////////////////////////
#ifdef  DEBUG
#define COUT(x) \
           COUT ## x

#if HARD_DEBUG_LEVEL >= 1
#define COUT1 \
    if (SOFT_DEBUG_LEVEL >= 1 ) \
      cout
#else 
#define COUT1 if (NO) cout
#endif
     
#if HARD_DEBUG_LEVEL >= 2
#define COUT2 \
     if (SOFT_DEBUG_LEVEL >= 2 ) \
       cout

#else 
#define COUT2 if (NO) cout
#endif
     
#if HARD_DEBUG_LEVEL >= 3
#define COUT3 \
     if (SOFT_DEBUG_LEVEL >= 3 ) \
       cout
#else
#define COUT3 if (NO) cout
#endif
     
#if HARD_DEBUG_LEVEL >= 4
#define COUT4 \
     if (SOFT_DEBUG_LEVEL >= 4 ) \
       cout
#else 
#define COUT4 if (NO) cout
#endif
     
     
#else  
#define COUT(x) if (NO) cout
#endif

#define COUT0 \
           cout

#endif /* _DEBUG_H */
