/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/

#include <unistd.h>

#include "gui_gtk.h"
#include "gui.h"
#include "gui_video.h"
#include "gui_audio.h"
#include "gui_exec.h"
#include "gui_flags.h"
#include "gui_banner.h"
#include "gui_keys.h"
#include "gui_update.h"

// GUI-modules
GuiFlags* flags   = NULL;
GuiVideo* video   = NULL;
GuiAudio* audio   = NULL;
GuiExec* exec     = NULL;
GuiBanner* banner = NULL;
GuiKeys* keys     = NULL;
GuiUpdate* update = NULL;

/* ORXONOXGUI */

/**
   \brief Initializes the Gui
*/
Gui::Gui(int argc, char *argv[])
{
  Window* orxonoxGUI = NULL;

  initGUI(argc, argv);

  orxonoxGUI = new Window( "grafical " PACKAGE_NAME " loader, "PACKAGE_VERSION);
  {
    Box* windowBox = new Box ('h');
    {
      banner = new GuiBanner();
      windowBox->fill (banner->getWidget());
      
      Box* optionBoxL = new Box('v');
      {
	Box* avBox = new Box('h');
	
	video = new GuiVideo();
	avBox->fill(video->getWidget());
	audio = new GuiAudio();
	avBox->fill(audio->getWidget());
      
	optionBoxL->fill(avBox);

	keys = new GuiKeys();
	optionBoxL->fill(keys->getWidget());
	windowBox->fill(optionBoxL);
      }
      Box* optionBoxR = new Box('v');
      {
	exec = new GuiExec();
	optionBoxR->fill(exec->getWidget());
	
	flags = new GuiFlags();
	
	optionBoxR->fill(flags->getWidget());
	
	update = new GuiUpdate();
	optionBoxR->fill(update->getWidget());
      }
      windowBox->fill(optionBoxR);
    }
    orxonoxGUI->fill(windowBox);
  }
  // Reading Values from File
  exec->setConfDir(GUI_DEFAULT_CONF_DIR);
  exec->setConfFile(GUI_DEFAULT_CONF_FILE);
  exec->readFromFile(Window::mainWindow);
  // Merging changes to the Options from appended flags.
  for (int optCount = 1; optCount < argc; optCount++)
    Window::mainWindow->walkThrough(Widget::flagCheck, argv[optCount], 0);

  flags->setTextFromFlags(Window::mainWindow);
  Window::mainWindow->showall();
  
  Window::mainWindow->walkThrough(Widget::redrawOptions, 1);

  //// Handling special Cases. ///

  // case update //
#ifdef HAVE_CURL
  if (static_cast<Option*>(Window::mainWindow->findWidgetByName(CONFIG_NAME_AUTO_UPDATE, 0))->value == 1)
    {
      update->checkForUpdates();
    }
#endif /* HAVE_CURL */

  mainloopGUI();
#ifndef HAVE_GTK2
  GuiExec::startOrxonox(NULL, exec);
#endif /* HAVE_GTK2 */
}

bool Gui::startOrxonox = false;

/**
   \brief Destructor.
*/
Gui::~Gui(void)
{
  delete video;
  delete audio;
  delete exec;
  delete flags;
  delete banner;
  delete keys;
  delete update;
}
