/*!
  \file gui_keys.h
  \brief File that holds the class that creates the Keyboard-Options.
*/

#ifndef _GUI_KEYS_H
#define _GUI_KEYS_H

#include "gui.h"
#include "gui_element.h"
#include "gui_gtk.h"

#ifdef HAVE_GTK2
#include <gdk/gdkkeysyms.h>
#endif /* HAVE_GTK2 */

/**
   \brief defines the Possible Player Keys
*/
enum KEYS {UP, DOWN, LEFT, RIGHT, SHOOT};

//! One KeyOption has one InputKey
struct InputKey
{
  Box* pKeyBox;           //!< One Box that holds the Keys
  Button* pKeyButton;     //!< The Button for changing the Key.
  OptionLabel* pKeyOLabel;//!< The Label for displaying the Key-setting.
};

//! Class that creates the Keys-Options.
class GuiKeys : public GuiElement
{
 public:
  GuiKeys(void);
  ~GuiKeys(void);

  static Window* inputWindow; //!< A Window that gets keyboard clicks. Static, because only one needed.
  static Button* inputButton; //!< A Button that gets keyboard clicks. Static, because only one needed.
  static long keySignal;      //!< A keySignal that handles keyboard clicks. Static, because only one needed.
};

//! Class to hold infos about a Player
class Player
{
 private:
  Button* openButton;     //!< The OpenButton for this key-settings.

 public:
  Player(char* player);


  Button* getOpenButton(void);

  void setkey(KEYS key);
  
};

Widget* addKey(KEYS key, char* name);
#ifdef HAVE_GTK2
gint inputWindowEvent(GtkWidget* w, GdkEventKey* event, void* widget);
gint key_cb(GtkWidget* w, GdkEventKey* event, void* inputKey);
#endif /* HAVE_GTK2 */


#endif /* _GUI_KEYS_H */
