/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/

#include "gui_keys.h"

#include <string.h>

/**
   \brief Creates an Keyboard-Frame
*/
GuiKeys::GuiKeys(void)
{
  Frame* keysFrame;      //!< The Frame that holds the keyOptions.

  keysFrame = new Frame("Keyboard-Options:");
  {
    Box* keysBox;          //!< The Frame that holds the keyOptions.
    
    //  keysFrame->setGroupName("Keyboard");
    keysBox = new Box('h');
    {
      Player* player1;       //!< The first Player's keys.
      Player* player2;       //!< The seconds Player's keys.
      Button* misc;          //!< Other keyboeard options come here. \todo include some like pause, quit and so on.
      
      player1 = new Player("player1");
      player2 = new Player("player2");
      
      keysBox->fill(player1->getOpenButton());
      keysBox->fill(player2->getOpenButton());
    }
    keysFrame->fill(keysBox);
  }
  
  // setting up the Input Windows that receives keystrokes.
  this->inputWindow = new Window("inputWindow");
  this->inputButton = new Button("test");
#ifdef HAVE_GTK2
  this->inputWindow->connectSignal("destroy",  Widget::doNothingSignal);
  this->inputWindow->connectSignal("delete_event", Widget::doNothingSignal);
#endif /* HAVE_GTK2 */
  this->inputWindow->fill(inputButton);
  
  this->setMainWidget(keysFrame);
}

/**
   \brief Destructs the Keys-stuff
*/
GuiKeys::~GuiKeys(void)
{
  // nothing to do here.
}


Window* GuiKeys::inputWindow = NULL;
Button* GuiKeys::inputButton = NULL;
long GuiKeys::keySignal = 0;


/* PLAYER */

/**
   \brief Creates new inputs for a player
   \param player the name of the Player
*/
Player::Player(char* player)
{
  Window* pKeyWindow;     //!< The Window for a new Key-setting.

  char* windowName = new char[strlen(player)+12];
  strcpy(windowName, "KeySets: ");
  strcat(windowName, player);
  pKeyWindow = new Window(windowName);
  delete windowName;
  {
    Frame* pKeyFrame;       //!< The Frame for a new Key-setting.

    pKeyFrame = new Frame(windowName);
    {
      Box* pKeysBox;          //!< The Box that holds the Key-settings.
      pKeysBox = new Box('v');
      {
	Button* closeButton;    //!< The CloseButton for this key-settings.

	pKeysBox->setGroupName(player);
	pKeysBox->fill(addKey(UP, "up"));
	pKeysBox->fill(addKey(DOWN, "down"));
	pKeysBox->fill(addKey(LEFT, "left"));
	pKeysBox->fill(addKey(RIGHT, "right"));
	pKeysBox->fill(addKey(SHOOT, "fire"));
	closeButton = new Button("close");
#ifdef HAVE_GTK2
	closeButton->connectSignal("button_press_event", pKeyWindow, Window::windowClose);
#endif /* HAVE_GTK2 */

	pKeysBox->fill(closeButton);
      }
      pKeyFrame->fill(pKeysBox);
    }
    pKeyWindow->fill(pKeyFrame);
  }
  Window::addWindow(pKeyWindow);
#ifdef HAVE_GTK2
  pKeyWindow->connectSignal("destroy", pKeyWindow, Window::windowClose);
  pKeyWindow->connectSignal("delete_event", pKeyWindow, Window::windowClose);
#endif /* HAVE_GTK2 */
  
  this->openButton = new Button(player);
#ifdef HAVE_GTK2
  this->openButton->connectSignal("button_press_event", pKeyWindow, Window::windowOpen);
#endif /* HAVE_GTK2 */
}

/**
   \returns the OpenButton of a Player
*/
Button* Player::getOpenButton(void)
{
  return this->openButton;
}

/**
   \brief sets a new Key(only output)
   \param key the new Key.
*/
void Player::setkey(KEYS key)
{
  PRINT(4)("setting up Key: %d\n", key);
}

/**
   \brief adds a new Key.
   \param key the number of the Key
   \param name The name of the new Key.
   \returns A widget that has the Key-Box
*/
Widget* addKey(KEYS key, char* name)
{
  InputKey* inputKey = new InputKey;
  inputKey->pKeyBox = new Box();
  inputKey->pKeyButton = new Button(name);
  inputKey->pKeyOLabel = new OptionLabel(name, name);
  inputKey->pKeyOLabel->saveability();

#ifdef HAVE_GTK2
  //inputKey->pKeyButton->connectSignal("key_press_event", inputKey->pKeyButton, key_cb);
  inputKey->pKeyButton->connectSignal("button_press_event", inputKey, inputWindowEvent);
#endif /* HAVE_GTK2 */
  inputKey->pKeyBox->fill(inputKey->pKeyButton);
  inputKey->pKeyBox->fill(inputKey->pKeyOLabel);
  return inputKey->pKeyBox;
}


#ifdef HAVE_GTK2
gint inputWindowEvent(GtkWidget* w, GdkEventKey* event, void* inputKey)
{
  GuiKeys::inputButton->setTitle("press a Key");
  GuiKeys::keySignal = GuiKeys::inputButton->connectSignal("key_press_event", inputKey, key_cb);
  GuiKeys::inputWindow->open();
}
  
/**
   \brief Function which gets keystrokes
   \param w the widget that released the Function.
   \param event The event that happened.
   \param Widget the Widget which will be applied.
   \returns Nothing
*/
gint key_cb(GtkWidget* w, GdkEventKey* event, void* inputKey)
{
  InputKey* inputkey =(InputKey*) inputKey;
  char title [20];

  switch(event->keyval) 
    {
    case GDK_Up:
      strcpy(title, "UP");
      break;
    case GDK_Down:
      strcpy(title, "DOWN");
      break;
    case GDK_Left:
      strcpy(title, "LEFT");
      break;
    case GDK_Right:
      strcpy(title, "RIGHT");
      break;
      
    case GDK_space:
      strcpy(title, "SPACE");
      break;
      
    case GDK_Return:
      strcpy(title, "RETURN");
      break;
      
      // Special Keys //
    case GDK_BackSpace:
      strcpy(title, "BACKSPACE");
      break;
    case GDK_Scroll_Lock:
      strcpy(title, "SCROLLOCK");
      break;
    case GDK_minus:
      strcpy(title, "MINUS");
      break;
    case GDK_plus:
      strcpy(title, "PLUS");
      break;
    case GDK_slash:
      strcpy(title, "SLASH");
      break;
    case GDK_period:
      strcpy(title, "PERIOD");
      break;
    case GDK_comma:
      strcpy(title, "COMMA");
      break;
    case GDK_colon:
      strcpy(title, "COLON");
      break;
    case GDK_semicolon:
      strcpy(title, "SEMICOLON");
      break;
    case GDK_less:
      strcpy(title, "LESS");
      break;
    case GDK_equal:
      strcpy(title, "EQUALS");
      break;
    case GDK_greater:
      strcpy(title, "GREATER");
      break;
    case GDK_question:
      strcpy(title, "QUESTION");
      break;
    case GDK_at:
      strcpy(title, "AT");
      break;
    case GDK_bracketleft:
      strcpy(title, "LEFTBRACKET");
      break;
    case GDK_bracketright:
      strcpy(title, "RIGHTBRACKET");
      break;
    case GDK_backslash:
      strcpy(title, "BACKSLASH");
      break;
    case GDK_underscore:
      strcpy(title, "UNDERSCORE");
      break;
    case GDK_quoteleft:
      strcpy(title, "BACKQUOTE");
      break;

    case GDK_Page_Up:
      strcpy(title, "PAGEUP");
      break;
    case GDK_Page_Down:
      strcpy(title, "PAGEDOWN");
      break;
    case GDK_Home:
      strcpy(title, "HOME");
      break;
    case GDK_Insert:
      strcpy(title, "INSERT");
      break;
      
    case GDK_Escape:
      strcpy(title, "ESCAPE");
      break;
    case GDK_Tab:
      strcpy(title, "TAB");
      break;
    case GDK_Shift_L:
      strcpy(title, "LSHIFT");
      break;
    case GDK_Shift_R:
      strcpy(title, "R_SHIFT");
      break;
    case GDK_Control_L:
      strcpy(title, "LCTRL");
      break;
    case GDK_Control_R:
      strcpy(title, "RCTRL");
      break;
    case GDK_Alt_L:
      strcpy(title, "LALT");
      break;
    case GDK_Alt_R:
      strcpy(title, "RALT");
      break;
      // FXX KEYS //
    case GDK_F1:
      strcpy(title, "F1");
      break;
    case GDK_F2:
      strcpy(title, "F2");
      break;
    case GDK_F3:
      strcpy(title, "F3");
      break;
    case GDK_F4:
      strcpy(title, "F4");
      break;
    case GDK_F5:
      strcpy(title, "F5");
      break;
    case GDK_F6:
      strcpy(title, "F6");
      break;
    case GDK_F7:
      strcpy(title, "F7");
      break;
    case GDK_F8:
      strcpy(title, "F8");
      break;
    case GDK_F9:
      strcpy(title, "F9");
      break;
    case GDK_F10:
      strcpy(title, "F10");
      break;
    case GDK_F11:
      strcpy(title, "F11");
      break;
    case GDK_F12:
      strcpy(title, "F12");
      break;
      
      
    default:
      char* tmp;
      sprintf(tmp, "%c", event->keyval);
      printf("other key %s \n", tmp);
      strcpy(title, tmp);
      break;
    }

  inputkey->pKeyOLabel->setValue(title);
  GuiKeys::inputButton->disconnectSignal(GuiKeys::keySignal);
  GuiKeys::inputWindow->close();
}
#endif /* HAVE_GTK2 */
