/*!
  \file orxonox_gui_video.h
  \brief File that holds the class that creates the Video-Options.
*/
#ifndef _ORXONOX_GUI_VIDEO_H
#define _ORXONOX_GUI_VIDEO_H

#include "orxonox_gui.h"
#include "orxonox_gui_element.h"

//! Class that creates the Video-Options.
class OrxonoxGuiVideo : public OrxonoxGuiElement
{
 private:
  Frame* videoFrame;        //!< The Frame that holds the video options.
  Box* videoBox;            //!< The Box that holds the video options.
  CheckButton* fullscreen;  //!< CheckButton for fullscreen-mode
  Menu* resolution;         //!< Menu for the resolution
  CheckButton* wireframe;   //!< CheckButton for wireframe Mode.

  // advanced-Performance-Options
  Window* advancedWindow;   //!< A Window to display advanced options.
  Button* advancedButton;   //!< A Button to open the Advanced Video Performance Window.
  Box* advancedBox;         //!< A Box to pack the options into.
  CheckButton* shadows;     //!< CheckButton for shadows
  CheckButton* fog;         //!< CheckButton for fog.
  CheckButton* reflections; //!< CheckButton for reflections
  CheckButton* textures;    //!< CheckButton for textures
  Menu* textureDetail;      //!< Menu for the Texture-Detail.
  
  Label* modelDetailLabel;  //!< Label for model-detail.
  Menu* modelDetail;        //!< model-detail.
  
  Label* antiAliasingLabel; //!< Label for the anti-aliasing mode.
  Menu* antiAliasing;       //!< Menu for the Antialiasing-mode.

  Label* filterMethodLabel; //!< Label for filtering-Method.
  Menu* filterMethod;       //!< Menu for filtering Method.

  Button* closeButton;      //!< A Button to close the Advanced-settingsWindow.

  Button* advancedWindowGetButton(void);
  void advancedWindowCreate(void);
  
 public:
  OrxonoxGuiVideo(void);
  ~OrxonoxGuiVideo(void);

  void getResolutions(Menu* menu);
  

};
#endif /* _ORXONOX_GUI_VIDEO_H */
