/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/


#include "orxonox_gui_video.h"

#include "glincl.h"

/**
   \brief Creates the Video-Option-Frame
*/
OrxonoxGuiVideo::OrxonoxGuiVideo(void)
{
  this->videoFrame = new Frame("Video-Options:");
  this->videoBox = new Box('v');
  this->videoFrame->setGroupName("video");
  
  this->fullscreen = new CheckButton("Fullscreen-mode");
  this->fullscreen->setFlagName("windowed", "q", 1);
  this->fullscreen->saveability();
  this->videoBox->fill(this->fullscreen);
  this->resolution = new Menu("Resolution");
  this->getResolutions(this->resolution);
  this->resolution->saveability();
  this->videoBox->fill(this->resolution);
  this->wireframe = new CheckButton("WireFrame-mode");
  this->wireframe->setFlagName("wireframe", "w", 0);
  this->wireframe->saveability();
  this->videoBox->fill(this->wireframe);

  this->advancedWindowCreate();
  this->videoBox->fill(this->advancedWindowGetButton());

  this->videoFrame->fill(videoBox);
  this->setMainWidget(this->videoFrame);
}

/**
   \brief Destructs the Video-stuff
*/
OrxonoxGuiVideo::~OrxonoxGuiVideo(void)
{
  // nothing to do here.
}

/**
   \brief Creates a window, and all it contains for the Source-update.
*/
void OrxonoxGuiVideo::advancedWindowCreate(void)
{
  // the button, that opens this Window.
  this->advancedButton = new Button("advanced");

  // the Window itself
  this->advancedWindow = new Window("Advanced Video Options");
  this->advancedWindow->setGroupName("advancedVideoOptions");

  this->advancedBox = new Box('v');

  // Advanced Performance Options
  this->shadows = new CheckButton("Shadows");
  this->shadows->saveability();
  this->advancedBox->fill(this->shadows);

  this->fog = new CheckButton("Fog");
  this->fog->saveability();
  this->advancedBox->fill(this->fog);

  this->reflections = new CheckButton("Reflections");
  this->reflections->saveability();
  this->advancedBox->fill(this->reflections);

  this->textures = new CheckButton("Textures");
  this->textures->saveability();
  this->advancedBox->fill(this->textures);

  this->textureDetail = new Menu("Texture Detail", "low", "medium", "high", "lastItem");
  this->textureDetail->saveability();
  this->advancedBox->fill(this->textureDetail);

  this->modelDetailLabel = new Label("Model Detail");
  this->advancedBox->fill(this->modelDetailLabel);
  this->modelDetail = new Menu("Model Detail", "low", "medium", "high", "lastItem");
  this->modelDetail->saveability();
  this->advancedBox->fill(this->modelDetail);

  this->antiAliasingLabel = new Label("Anti-Aliasing-depth:");
  this->advancedBox->fill(this->antiAliasingLabel);
  this->antiAliasing = new Menu("Anti Aliasing", "0", "1", "2", "4", "8",  "lastItem");
  this->antiAliasing->saveability();
  this->advancedBox->fill(this->antiAliasing);

  this->filterMethodLabel = new Label("Filtering Method:");
  this->advancedBox->fill(this->filterMethodLabel);
  this->filterMethod = new Menu("Filtering Method", "none", "linear", "bilinear", "trilinear", "anisortopic", "lastItem");
  this->filterMethod->saveability();
  this->advancedBox->fill(this->filterMethod);
  
  this->closeButton = new Button("close");
  this->advancedBox->fill(this->closeButton);

  this->advancedWindow->fill(advancedBox);
#ifdef HAVE_GTK2 
  this->advancedButton->connectSignal("button_press_event", this->advancedWindow, Window::windowOpen);
  this->closeButton->connectSignal("button_press_event", this->advancedWindow, Window::windowClose);
  this->advancedWindow->connectSignal("destroy", this->advancedWindow, Window::windowClose);
  this->advancedWindow->connectSignal("delete_event", this->advancedWindow, Window::windowClose);
#endif /* HAVE_GTK2 */
   Window::addWindow(this->advancedWindow);

}

/**
   \returns A Pointer to the Button of the UpdaterSourceWindow
*/
Button* OrxonoxGuiVideo::advancedWindowGetButton(void)
{
  return this->advancedButton;
}

void OrxonoxGuiVideo::getResolutions(Menu* menu)
{
  SDL_Init(SDL_INIT_VIDEO);
  SDL_Rect **modes;
  int i;
  int x = 0,y =0; // check for difference
  char tmpChar[100];
  
  /* Get available fullscreen/hardware modes */
  modes=SDL_ListModes(NULL, SDL_FULLSCREEN|SDL_HWSURFACE);
  
  /* Check is there are any modes available */
  if(modes == (SDL_Rect **)0){
    PRINTF(2)("No video-modes available!\n");
    exit(-1);
  }
  
  /* Check if our resolution is restricted */
  if(modes == (SDL_Rect **)-1){
    PRINTF(2)("All resolutions available.\n");
  }
  else{
    /* Print valid modes */
    PRINT(4)("Available Modes\n");
    for(i = 0; modes[i] ;++i)
      {
	if (x != modes[i]->w || y != modes[i]->h)
	  { 
	    PRINT(4)("  %d x %d\n", modes[i]->w, modes[i]->h);
	    sprintf(tmpChar, "%dx%d", modes[i]->w, modes[i]->h);
	    menu->addItem(tmpChar);
	    x = modes[i]->w; y = modes[i]->h;
	  }
      }
  }
  SDL_Quit();
}
