/*!
  \file orxonox_gui_keys.h
  \brief File that holds the class that creates the Keyboard-Options.
*/

#ifndef _ORXONOX_GUI_KEYS_H
#define _ORXONOX_GUI_KEYS_H

#include "orxonox_gui.h"
#include "orxonox_gui_element.h"

#ifdef HAVE_GTK2
#include <gdk/gdkkeysyms.h>
#endif /* HAVE_GTK2 */

/**
   \brief defines the Possible Player Keys
*/
enum KEYS {UP, DOWN, LEFT, RIGHT, SHOOT};

class Player;
//! Class that creates the Keys-Options.
class OrxonoxGuiKeys : public OrxonoxGuiElement
{
 private:
  Frame* keysFrame;      //!< The Frame that holds the keyOptions.
  Box* keysBox;          //!< The Frame that holds the keyOptions.
  Player* player1;       //!< The first Player's keys.
  Player* player2;       //!< The seconds Player's keys.
  Button* misc;          //!< Other keyboeard options come here. \todo include some like pause, quit and so on.

 public:
  OrxonoxGuiKeys(void);
  ~OrxonoxGuiKeys(void);
};

//! Class to hold infos about a Player
/**
   \todo split into subclass and superclass ButtonConfigurator
*/
class Player
{
 private:
  Window* pKeyWindow;     //!< The Window for a new Key-setting.
  Frame* pKeyFrame;       //!< The Frame for a new Key-setting.
  Button* openButton;     //!< The OpenButton for this key-settings.
  Button* closeButton;    //!< The CloseButton for this key-settings.
  Box* pKeysBox;          //!< The Box that holds the Key-settings.
  
  //! One KeyOption has one InputKey
  struct InputKey
  {
    Box* pKeyBox;           //!< One Box that holds the Keys
    Button* pKeyButton;     //!< The Button for changing the Key.
    OptionLabel* pKeyOLabel;//!< The Label for displaying the Key-setting.
  };

  InputKey* inputKey[10];     //!< Buttons-array. \todo make it dynamic.

  static Window* inputWindow; //!< A Window that gets keyboard clicks. Static, because only one needed.
  static Button* inputButton; //!< A Button that gets keyboard clicks. Static, because only one needed.
  static long keySignal;      //!< A keySignal that handles keyboard clicks. Static, because only one needed.
 public:
  Player(char* player);

  Widget* addKey(KEYS key, char* name);

  Button* getOpenButton(void);

#ifdef HAVE_GTK2
  static gint inputWindowEvent(GtkWidget* w, GdkEventKey* event, void* widget);
  static gint key_cb(GtkWidget* w, GdkEventKey* event, void* inputKey);
#endif /* HAVE_GTK2 */
  void setkey(KEYS key);
  
};



#endif /* _ORXONOX_GUI_KEYS_H */
