/*!
  \file orxonox_gui_flags.h
  \brief File that holds the class that creates the flags-Text.
*/

#ifndef _ORXONOX_GUI_FLAGS_H
#define _ORXONOX_GUI_FLAGS_H

#include "orxonox_gui.h"
#include "orxonox_gui_element.h"

//! Class that creates the flags-Text.
class OrxonoxGuiFlags : public OrxonoxGuiElement
{
 private:
  Frame* flagsFrame;          //!< The Frame that holds the flagsDisplay.
  Box* flagsBox;              //!< The Box that holds the flagsDisplay.
  CheckButton* shortFlags;    //!< CheckButton to change the display of short and long flags \todo show long if long not availible...
  Label* flagsLabel;          //!< The Label of the Flags

 public:
  OrxonoxGuiFlags(void);
  ~OrxonoxGuiFlags(void);

  void setTextFromFlags(Widget* widget);
  static void flagsText(Widget* widget, void* flagInfo);
  
  //! Struct that handles flag information.
  struct FlagInfo
  {
    CheckButton* shortFlags;     //!< Button for the flag.
    Label* flagsLabel;           //!< Label for the flag.
  };
};
#endif /* _ORXONOX_GUI_FLAGS_H */
