/*!
  \file orxonox_gui_exec.h
  \brief File that holds the class that creates the execute-Options.
*/

#ifndef _ORXONOX_GUI_EXEC_H
#define _ORXONOX_GUI_EXEC_H

#include "orxonox_gui.h"
#include "orxonox_gui_element.h"

#include <stdio.h>
using namespace std;

//! Class that creates the execute-Options.
class OrxonoxGuiExec : public OrxonoxGuiElement
{
 private:
  Frame* execFrame;            //!< The Frame that holds the ExecutionOptions.
  Box* execBox;                //!< The Box that holds the ExecutionOptions.
  Button* start;               //!< The start Button of orxonox.
  CheckButton* saveSettings;   //!< A CheckBox for if the Options should be saved.
  Menu* verboseMode;           //!< A Menu for setting the verbose-Mode. \todo setting up a verbose-class.
  CheckButton* alwaysShow;     //!< A CheckButton, for if orxonox should start with or without gui.
  Button* quit;                //!< A Button to quit the Gui without starting orxonox.
  char* confDir;               //!< The directory of the orxonox-configuration-files.
  char* configFile;            //!< The name of the .orxonox.conf(ig)-file.
  FILE* CONFIG_FILE;           //!< Filehandler for reading and writing.
  
  //! A struct that holds informations about variables.
  struct VarInfo
  {
    char* variableName;        //!< The Name of this variable;
    char* variableValue;       //!< The Value this variable gets.
  };

 public:
  OrxonoxGuiExec(void);
  ~OrxonoxGuiExec(void);
  
  void setConfFile(char* confFile);
  void setConfDir(char* confDir);
  void setFileName(char* fileName);
  char* getConfigFile(void) const;
  int shouldsave(void);
  void writeToFile(Widget* widget);
  void writeFileText(Widget* widget, int depth);
  void readFromFile(Widget* widget);
  static void readFileText(Widget* widget, void* varInfo);
  Widget* locateGroup(Widget* widget, char* groupName, int depth);

#ifdef HAVE_GTK2
  static int startOrxonox(GtkWidget *widget, void* data);
  static int quitOrxonox(GtkWidget *widget, void* data);
#else /* HAVE_GTK2 */
  static int startOrxonox(void* widget, void* data);
  static int quitOrxonox(void* widget, void* data);
#endif /* HAVE_GTK2 */
};

//! A simple hashtable 
struct HashTable
{
  char* name;           //!< name of the entry
  char* value;          //!< value of the entry
  HashTable* next;      //!< pointer to the next entry
};


#endif /* _ORXONOX_GUI_EXEC_H */
