/*!
  \file orxonox_gui_banner.h
  \brief  File that holds the class that creates the Banner-Image.\n
  This is Commercial :-)
*/

#ifndef _ORXONOX_GUI_BANNER_H
#define _ORXONOX_GUI_BANNER_H

#include "orxonox_gui.h"
#include "orxonox_gui_element.h"

//! Class that creates the Banner-Image
class OrxonoxGuiBanner : public OrxonoxGuiElement
{
 private:
  // the banner Frame
  Frame* bannerFrame;       //!< The frame that holds the Banner.
  Box* bannerBox;           //!< The box that holds the Banner.
  EventBox* bannerEventBox; //!< an Image needs an EventBox to catch klicks.
  Image* bannerImage;       //!< The Image for the Banner.
  Label* bannerLabel;       //!< The Label of the Banner.

  // the logo Window
  Window* logoWindow;       //!< The Window that holds the Orxonox-CrewLogo.
  EventBox* logoEventBox;   //!< The EventBox that holds the Orxonox-CrewLogo. it has to be an eventbox, because Images can not receive clicks.
  Box* logoBox;             //!< The Box that holds the Orxonox-CrewLogo
  Image* logoImage;         //!< The Orxonox-CrewLogo-Image
  Label* logoLabel;         //!< The Label for the Orxonox-CrewLogo

 public:
  OrxonoxGuiBanner(void);
  ~OrxonoxGuiBanner(void);
};


#endif /* _ORXONOX_GUI_BANNER_H */
