/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/

#include "orxonox_gui_banner.h"

/**
   \brief Creates a new BannerEventBox and its content.
*/
OrxonoxGuiBanner::OrxonoxGuiBanner(void)
{
  // Banner Itself //
  this->bannerEventBox = new EventBox("BannerEventBox");
  this->bannerImage = new Image("banner.xpm");
  this->bannerEventBox->fill(this->bannerImage);

  // Banner Window //
  this->logoWindow = new Window("Logo");

#ifdef HAVE_GTK2
  this->bannerEventBox->connectSignal("button_press_event", this->logoWindow, Window::windowOpen);

  this->logoWindow->connectSignal("destroy", this->logoWindow, Window::windowClose);
  this->logoWindow->connectSignal("delete_event", this->logoWindow, Window::windowClose);
#endif /* HAVE_GTK2 */
  this->logoEventBox = new EventBox();
  this->logoBox = new Box('v');
  this->logoLabel = new Label("OrxOnoX, Version: " PACKAGE_VERSION);
  this->logoImage = new Image("banner.xpm");
  this->logoEventBox->fill(this->logoImage);
  
  this->logoBox->fill(this->logoLabel);
  this->logoBox->fill(this->logoEventBox);
#ifdef HAVE_GTK2
  this->logoEventBox->connectSignal("button_press_event", this->logoWindow, Window::windowClose);
#endif /* HAVE_GTK2 */

  this->logoWindow->fill(this->logoBox);
  
  Window::addWindow(this->logoWindow);

  this->setMainWidget(bannerEventBox);
}

/**
   \brief Destructs it.
*/
OrxonoxGuiBanner::~OrxonoxGuiBanner(void)
{
  // nothing to do here
}
