/*!
  \file orxonox_gui_audio.h
  \brief File that holds the class that creates the Audio-Options.
*/

#ifndef _ORXONOX_GUI_AUDIO_H
#define _ORXONOX_GUI_AUDIO_H

#include "orxonox_gui.h"
#include "orxonox_gui_element.h"

//! Class that creates the Audio-Options.
class OrxonoxGuiAudio : public OrxonoxGuiElement
{
 private:
  Frame* audioFrame;        //!< The Frame that holds the audio Options.
  Box* audioBox;            //!< The Box that holds the audio Options.
  CheckButton* enableSound; //!< A Ckeckbutton for enabling Sound.
  Slider* musicVolume;      //!< A Slider for music volume.
  Slider* effectsVolume;    //!< A Slider for effects volume.
 public:
  OrxonoxGuiAudio(void);
  ~OrxonoxGuiAudio(void);
};
#endif /* _ORXONOX_GUI_AUDIO_H */
