/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: ...
*/


/**
   \brief breaks a string into parts that were initially seperated by comma
   \param string the string to break into substrings
*/

#include "substring.h"

SubString::SubString( const char* string)
{
	n = 0;
	
	assert( string != NULL);
	
	for( int i = 0; i < strlen(string); i++) if( string[i] == ',') n++;

	n += 1;
	
	strings = new char*[n];
	
	assert( strings != NULL);
	
	int i = 0;
	int l = 0;
	
	const char* offset = string;
	char* end = strchr( string, ',');
	while( end != NULL)
	{
		assert( i < n);
		l = end - offset;
		strings[i] = new char[l + 1];
		assert( strings[i] != NULL);
		strncpy( strings[i], offset, l);
		strings[i][l] = 0;
		i++;
		end++;
		offset = end;
		end = strchr( offset, ',');
	}
	
	strings[i] = new char[l + 1];
	l = strlen( offset);
	strncpy( strings[i], offset, l);
	strings[i][l] = 0;
}

/**
   \brief removes the object from memory
*/
SubString::~SubString()
{
	for( int i = 0; i < n; i++)
	{
		delete strings[i];
	}
	
	delete strings;
}

/**
   \brief get the amount of substrings
   \returns the amount of substrings
*/
int SubString::getN()
{
	return n;
}

/**
   \brief get a particular substring
   \param i the ID of the substring to return
   \returns the designated substring or NULL if an invalid ID was given
*/
const char* SubString::getString( int i)
{
	if( i < n && i >= 0) return strings[i];
	else return NULL;
}
