/*! 
    \file particle_e,otter.h
    \brief Definition of a ParticleEmitter
*/

#ifndef _PARTICLE_EMITTER_H
#define _PARTICLE_EMITTER_H

#include "p_node.h"

// FORWARD DEFINITION 
struct Particle;
class ParticleSystem;


//! A default singleton class.
class ParticleEmitter : public PNode {

 public:
  ParticleEmitter(const Vector& direction, float angle = 20.0, float emissionRate = 1.0, 
		  float velocity = 1.0, float ttl = 1.0);
  virtual ~ParticleEmitter(void);

  /* controlling the emitter: interface */
  void start();
  void stop();

  /* controlling the behavour: these can be used as Animation interfaces */
  void setAngle(float angle);
  void setEmissionRate(float emissionRate);
  void setVelocity(float velocity);
  void setTTL(float ttl);

  /* some functions needed for internal use */
  void tick(float dt);

 private:
  Vector direction;     //!< emition direction
  float angle;          //!< max angle from the direction of the emitter
  float emissionRate;   //!< amount of particles per seconds emitted by emiter
  float velocity;       //!< the contant speed a particle gets if been emitted
  float timeToLive;     //!< this is the global time to live (ttl) definition
};

#endif /* _PARTICLE_EMITTER_H */
