/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: Patrick Boenzli
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "particle_emitter.h"

using namespace std;


/**
   \brief standard constructor
*/
ParticleEmitter::ParticleEmitter(const Vector& direction, float angle, float emissionRate, 
		  float velocity, float ttl)
{
   this->setClassName ("ParticleEmitter");
   this->direction = direction;
   this->angle = angle;
   this->emissionRate = emissionRate;
   this->velocity = velocity;
   this->timeToLive = ttl;
}



/**
   \brief standard destructor

*/
ParticleEmitter::~ParticleEmitter () 
{}


/**
   \brief this start the emitter
*/
void ParticleEmitter::start() {}


/**
   \brief this stops the emitter
*/
void ParticleEmitter::stop() {}




/* these are Animation interfaces: so you can change spec values as you want */

/**
   \brief set the angle of the emitter
   \param angle around the direction in which there are particles to be emitted

   if you want to change the value of this variable during emission time (to make it more dynamic)
   you will have to use the animation class
*/
void ParticleEmitter::setAngle(float angle)
{}


/**
   \brief set the emission rate
   \param sets the number of particles emitted per second

   if you want to change the value of this variable during emission time (to make it more dynamic)
   you will have to use the animation class
*/
void ParticleEmitter::setEmissionRate(float emissionRate)
{}


/**
   \brief sets the velocity of all particles emitted
   \param velocity of the emitted particles

   if you want to change the value of this variable during emission time (to make it more dynamic)
   you will have to use the animation class
*/
void ParticleEmitter::setVelocity(float velocity)
{}

/**
   \brief this set the time to life of a particle, after which it will die
   \param the time to live in seconds

   if you want to change the value of this variable during emission time (to make it more dynamic)
   you will have to use the animation class
*/
void ParticleEmitter::setTTL(float ttl)
{}


/**
   \brief this is called from the particle emitter to give the pulse of time...
   \param time passed since last tick
*/
void ParticleEmitter::tick(float dt)
{}
