/*!
  \file material.h
  \brief Contains the Material Class that handles Material for 3D-Objects.
  \todo free SDL-surface when deleting Material.
  \todo delete imgNameWithPath after use creation.
*/

#ifndef _MATERIAL_H
#define _MATERIAL_H


#if HAVE_CONFIG_H 
#include <config.h> 
#endif /* HAVE_CONFIG_H */

#ifndef NULL
#define NULL 0
#endif

// FORWARD DEFINITIONS //
class Texture;


//! Class to handle Materials.
class Material
{
 public:
  Material (const char* mtlName = NULL);
  ~Material ();

  bool select (void);

  void setName (const char* mtlName);
  char* getName (void);
  void setIllum (int illum);
  void setIllum (char* illum);
  void setDiffuse (float r, float g, float b);
  void setDiffuse (char* rgb);
  void setAmbient (float r, float g, float b);
  void setAmbient (char* rgb);
  void setSpecular (float r, float g, float b);
  void setSpecular (char* rgb);
  void setShininess (float shini);
  void setShininess (char* shini);
  void setTransparency (float trans);
  void setTransparency (char* trans);


 
  void addTexturePath(char* pathName);
 // MAPPING //
  void setDiffuseMap(const char* dMap);
  void setAmbientMap(const char* aMap);
  void setSpecularMap(const char* sMap);
  void setBump(const char* bump);

 private:
  char* name;        //!< The Name of the Material.
  int illumModel;    //!< The IlluminationModel is either flat or smooth.
  float diffuse [4]; //!< The diffuse color of the Material.
  float ambient [4]; //!< The ambient color of the Material.
  float specular [4];//!< The specular color of the Material.
  float shininess;   //!< The shininess of the Material.
  float transparency;//!< The transperency of the Material.

  Texture* diffuseTexture; //!< The diffuse texture of the Material.
  Texture* ambientTexture; //!< The ambient texture of the Material.
  Texture* specularTexture;//!< The specular texture of the Material.
  
  bool diffuseTextureSet; //!< Chekcs if the diffuse texture is Set.
  bool ambientTextureSet; //!< Chekcs if the ambient texture is Set.
  bool specularTextureSet;//!< Chekcs if the specular texture is Set.

};
#endif
