/*! 
    \file factory.h
    \brief philosophy stuff
*/

#ifndef _FACTORY_H
#define _FACTORY_H


/** creates a Subclass of Factory, that HOPEFULLY loads modules \todo check it for real */
#define CREATE_FACTORY(x) \
		class x ## Factory : public Factory { \
		 public:	\
		  x ## Factory (){setNext( NULL); setClassname( #x ); initialize();} \
		  ~x ## Factory () {}; \
		 private: \
			BaseObject* fabricate( TiXmlElement* root) \
			{ \
				if(!strcmp(root->Value(), getClassname())) return new  x ( root); \
				else if( getNext() != NULL) return getNext()->fabricate( root); \
				else return NULL; \
			} \
		}; \
		x ## Factory global_ ## x ## Factory;

#include "stdincl.h"

class BaseObject;

//! The Factory is
/**
	Very philosophic description, huh?
*/
class Factory {

 public:
  Factory ();
  ~Factory ();

	virtual BaseObject* fabricate( TiXmlElement* root);
	void initialize();
  void registerFactory( Factory* factory);
	void setClassname(char* name) {classname = name;}
	char* getClassname() {return classname;};
	void setNext( Factory* factory) {next = factory;}
	Factory* getNext() {return next;}
	
 private:
	char* classname;
	
  Factory* next;
};

// helper function

const char* grabParameter( TiXmlElement* root, const char* name);

#endif /* _FACTORY_H */

