

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 


   \todo: direction in which the projectile flights
   \todo: a target to set/hit
*/


#include "test_gun.h"

#include "stdincl.h"
#include "world_entity.h"
#include "model.h"
#include "test_bullet.h"

#include "vector.h"
#include "list.h"
#include "animation3d.h"

using namespace std;


/**
   \brief standard constructor

   creates a new weapon
*/
TestGun::TestGun (PNode* parent, const Vector& coordinate, const Quaternion& direction, int leftRight) 
  :  Weapon (parent, coordinate, direction) 
{
  this->model = (Model*)ResourceManager::getInstance()->load("models/test_gun.obj", OBJ, RP_CAMPAIGN);
  this->idleTime = 0.2f;
  this->leftRight = leftRight;

  if( this->leftRight == 0)
    this->projOffset = new Vector(1.0, 0.0, -0.35);
  else if( this->leftRight == 1)
    this->projOffset = new Vector(1.0, 0.0, 0.5);


  //this->dummy1 = new WorldEntity(); // a world entity that is not drawed: use this for the weapon 
  this->objectComponent1 = new PNode();
  this->animation1 = new Animation3D(this->objectComponent1);

  parent->addChild(this->objectComponent1, PNODE_ALL);

  this->animation1->setInfinity(ANIM_INF_CONSTANT);
  // ANIM_LINEAR was ANIM_NEG_EXP
  if( this->leftRight == W_LEFT)
    {
      this->animation1->addKeyFrame(Vector(-2.6, 0.1, 3.0), Quaternion(), 0.1, ANIM_LINEAR); 
      this->animation1->addKeyFrame(Vector(-3.0, 0.1, 3.0), Quaternion(), 0.5, ANIM_LINEAR);
      this->animation1->addKeyFrame(Vector(-2.6, 0.1, 3.0), Quaternion(), 0.1, ANIM_LINEAR);
    }
  else if( this->leftRight == W_RIGHT)
    {
      this->animation1->addKeyFrame(Vector(-2.6, 0.1, -2.5), Quaternion(), 0.1, ANIM_LINEAR);
      this->animation1->addKeyFrame(Vector(-3.0, 0.1, -2.5), Quaternion(), 0.5, ANIM_LINEAR);
      this->animation1->addKeyFrame(Vector(-2.6, 0.1, -2.5), Quaternion(), 0.1, ANIM_LINEAR);
    }
}


/**
   \brief standard deconstructor
*/
TestGun::~TestGun () 
{
  // model will be deleted from WorldEntity-destructor
}


/**
   \brief this activates the weapon

   This is needed, since there can be more than one weapon on a ship. the 
   activation can be connected with an animation. for example the weapon is 
   been armed out. 
*/
void TestGun::activate()
{}


/**
   \brief this deactivates the weapon

   This is needed, since there can be more than one weapon on a ship. the 
   activation can be connected with an animation. for example the weapon is 
   been armed out.
*/
void TestGun::deactivate()
{}


/**
   \brief fires the weapon
   
   this is called from the player.cc, when fire-button is been pushed
*/
void TestGun::fire()
{
  if( !this->hasWeaponIdleTimeElapsed())
    {
      this->weaponIdle();
      return;
    }
  Projectile* pj = new TestBullet(this);

  pj->setAbsCoor(this->getAbsCoor() + *this->projOffset);
  pj->setAbsDir(this->getAbsDir());

  pj->setFlightDirection(this->getAbsDir());
  pj->setSpeed(this->getSpeed());

  this->worldEntities->add(pj);
  this->localTime = 0;
  
  this->animation1->replay();
}


/**
   \brief is called, when the weapon gets hit (=collide with something)
   \param from which entity it is been hit
   \param where it is been hit

   this may not be used, since it would make the game relay complicated when one
   can destroy the weapons of enemies or vice versa.
*/
void TestGun::hit (WorldEntity* entity, Vector* position) 
{}


/**
   \brief is called, when the weapon is destroyed

   this is in conjunction with the hit function, so when a weapon is able to get
   hit, it can also be destoryed.
*/
void TestGun::destroy () 
{}


/**
   \brief tick signal for time dependent/driven stuff
*/
void TestGun::tick (float time) 
{
  this->localTime += time;
}


/**
   \brief is called, when there is no fire button pressed
*/
void TestGun::weaponIdle()
{}


/**
   \brief this will draw the weapon
*/
void TestGun::draw () 
{
  /* draw gun body */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, 
		this->getAbsCoor ().y, 
		this->getAbsCoor ().z);  
  this->getAbsDir ().matrix (matrix);
  glMultMatrixf((float*)matrix);
  if( this->leftRight == W_RIGHT)
    glScalef(1.0, 1.0, -1.0);
  this->model->draw(1);
  glPopMatrix();

  /* draw objectComponent1: gun coil - animated stuff */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->objectComponent1->getAbsCoor ().x, 
		this->objectComponent1->getAbsCoor ().y, 
		this->objectComponent1->getAbsCoor ().z);
  this->objectComponent1->getAbsDir ().matrix (matrix);
  glMultMatrixf((float*)matrix);
  this->model->draw(0);
  glPopMatrix();
}

