/*!
  \file texture.h
  \brief Contains the texture class, that handles the reading of Images into Texutre-files.

  \todo free SDL-surface when deleting Material.
  \todo delete imgNameWithPath after use creation.
*/

#ifndef _TEXTURE_H
#define _TEXTURE_H

#include "glincl.h"

#include "debug.h"

#include <SDL_image.h>

//! A Class, that reads in Textures from different fileformats.
class Texture
{
 private:
  //! Struct to handle Infos about an Image
  struct Image
  {
    int rowSpan;    //!< The count of the rows this Image has.
    GLuint width;   //!< The width of the Image.
    GLuint height;  //!< The height of the Image.
    GLuint bpp;     //!< BytesPerPixel
    GLenum format;  //!< The Format of the PixelData
    GLuint type;    //!< Type of the Image.
    GLubyte *data;  //!< The Image Data comes here! DANGER: uncompressed data.
  };
  Image* pImage;    //!< The data of an Image
  GLuint texture;   //!< The Texture-ID of opengl from this Texture.
  SDL_Surface* map; //!< The map SDL initializes for this element.
  char* searchTextureInPaths(const char* texName) const;
  void swap(unsigned char &a, unsigned char &b);
 public:
  Texture(void);
  Texture(const char* imageName);
  ~Texture(void);
  /** \returns The textureID of this texture.  */
  inline GLuint getTexture(void) {return this->texture;} 
  bool loadTexToGL (Image* pImage);

  bool loadImage(const char* imageName);
};

#endif /* _TEXTURE_H */
