
#ifndef _LIST_H
#define _LIST_H

#include "compiler.h"
#ifndef NULL
#define NULL 0
#endif

//! An enum to list all the modes available when adding an object to a List
//enum ADDMODE {LIST_ADD_FIRST, LIST_ADD_LAST};
//! An enum to list the two searching directions available when removing an object from a List
//enum FINDMODE {LIST_FIND_BW, LIST_FIND_FW};



class WorldEntity;

class List {

 public:
  List ();
  ~List ();

  void add(WorldEntity* entity);
  void remove(WorldEntity* entity);
  void destroy();
  WorldEntity* firstElement();
  bool isEmpty();
  int getSize();
  WorldEntity* enumerate();
  WorldEntity* nextElement();
  WorldEntity* toArray();
  void debug();

 private:
  struct listElement
  {
    listElement* prev;
    WorldEntity* curr;
    listElement* next;
  };
  unsigned int size;
  listElement* first;
  listElement* last;
  listElement* currentEl;


};



template<class T> struct listElement
{
  listElement* prev;
  T* curr;
  listElement* next;
};

template<class T> class tIterator
{
 public:
  tIterator(listElement<T>* startElement);
  ~tIterator();
  
  T* nextElement();

 private:
  listElement<T>* currentEl;
  listElement<T>* tmpEl;
};


template<class T>
inline tIterator<T>::tIterator (listElement<T>* startElement) 
{
  this->currentEl = startElement;
  this->tmpEl = NULL;
}


template<class T>
inline tIterator<T>::~tIterator ()
{
  this->currentEl = NULL;
}


template<class T>
inline T* tIterator<T>::nextElement ()
{
  if( this->currentEl == NULL)
    return NULL;

  this->tmpEl = this->currentEl;
  this->currentEl = this->currentEl->next;
  return this->tmpEl->curr;
}



template<class T> class tList 
{
 public:
  tList ();
  ~tList ();

  void add(T* entity);
  void remove(T* entity);
  void destroy();
  T* firstElement();
  T* lastElement();
  bool isEmpty();
  int getSize();
  //T* enumerate();
  tIterator<T>* getIterator();
  T* nextElement();
  T* nextElement(T* toEntity);
  T* toArray();
  void debug();

 private:
  unsigned int size;
  listElement<T>* first;
  listElement<T>* last;
  listElement<T>* currentEl;
};


template<class T>
inline tList<T>::tList () 
{
  this->first = NULL;
  this->last = NULL;
  this->size = 0;
}

template<class T>
inline tList<T>::~tList () 
{
  this->currentEl = this->first;
  while(this->currentEl != NULL)
    {
      listElement<T>* le = this->currentEl->next;
      //delete this->currentEl->curr;
      delete this->currentEl;
      this->currentEl = le;
    }
  this->first = NULL;
  this->last = NULL;
  this->size = 0;
}


template<class T>
inline void tList<T>::add(T* entity)
{
  if( unlikely(entity == NULL)) return;
  listElement<T>* el = new listElement<T>;
  el->prev = this->last;
  el->curr = entity;
  el->next = NULL;

  this->last = el;

  if( unlikely(el->prev == NULL)) this->first = el; /* if first element */
  else el->prev->next = el;
  this->size++;
}


template<class T>
inline void tList<T>::remove(T* entity)
{
  this->currentEl = this->first;
  listElement<T>* te;
  while( this->currentEl != NULL)
    {
      if( unlikely(this->currentEl->curr == entity))
	{ 
	  if( unlikely(this->currentEl->prev  == NULL)) this->first = this->currentEl->next;
	  else this->currentEl->prev->next = this->currentEl->next;

	  if( unlikely(this->currentEl->next == NULL)) this->last = this->currentEl->prev;
	  else this->currentEl->next->prev = this->currentEl->prev;

	  delete this->currentEl;
	  this->size--;
	  return;
	}
      this->currentEl = this->currentEl->next;
    }
}


template<class T>
inline void tList<T>::destroy()
{
  this->currentEl = this->first;
  while(this->currentEl != NULL)
    {
      listElement<T>* le = this->currentEl->next;
      //delete this->currentEl->curr;
      delete this->currentEl;
      this->currentEl = le;
    }
  this->first = NULL;
  this->last = NULL;
  this->size = 0;
}


template<class T>
inline T* tList<T>::firstElement()
{
  return this->first->curr;
}


template<class T>
inline T* tList<T>::lastElement()
{
  return this->last->curr;
}


template<class T>
inline bool tList<T>::isEmpty()
{
  return (this->size==0)?true:false;
}


template<class T>
inline int tList<T>::getSize()
{
  return this->size;
}


/* deprecated */
/*
template<class T>
T* tList<T>::enumerate()
{
  //if( this->last == this->first == NULL) return NULL;
  if( this->size == 0) return NULL;
  this->currentEl = this->first;
  return this->currentEl->curr;
}
*/

template<class T>
inline tIterator<T>* tList<T>::getIterator()
{
  tIterator<T>* iterator = new tIterator<T>(this->first);
  return iterator;
}


/* deprecated */
template<class T>
T* tList<T>::nextElement()
{
  // if( this->last == this->first == NULL) return NULL;
  if( this->size == 0) return NULL;
  this->currentEl = this->currentEl->next;
  if( this->currentEl == NULL) return NULL;
  return this->currentEl->curr;
}


/**
   \brief this returns the next element after toEntity or the first if toEntity is last
*/
template<class T>
inline T* tList<T>::nextElement(T* toEntity)
{
  //if( this->last == this->first == NULL) return NULL;
  if(this->size == 0) return NULL;
  if( toEntity == NULL) return this->first->curr;
  if( toEntity == this->last->curr ) return this->first->curr;
  this->currentEl = this->first;
  while(this->currentEl->curr != toEntity && this->currentEl->next != NULL)
    {
      this->currentEl = this->currentEl->next;
    }
  if(this->currentEl == NULL) return NULL;
  return this->currentEl->next->curr;
}


template<class T>
T* tList<T>::toArray()
{}

#endif /* _LIST_H */
