/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/


#include "animation.h"
#include "debug.h"
#include "animation_player.h"


Animation::Animation(void)
{  
  // initialize a beginning KeyFrame, that will be deleted afterwards
  this->bHasKeys = false;
  this->bHandled = true;
  this->baseObject = NULL;

  // setting default values
  this->localTime = 0.0;
  this->bRunning = true;

  AnimationPlayer::getInstance()->addAnimation(this);
}

Animation::~Animation(void)
{
  this->doNotHandle();
}

void Animation::doNotHandle(void)
{
  if (this->bHandled)
    AnimationPlayer::getInstance()->removeAnimation(this);
}


void Animation::setInfinity(ANIM_INFINITY postInfinity)
{
  this->postInfinity = postInfinity;
}


void Animation::play()
{
  this->bRunning = true;
}


void Animation::stop()
{
  this->rewind();
  this->bRunning = true;
  this->tick(0.0);
  this->bRunning = false;
}
void Animation::pause()
{
  this->bRunning = false;
}
void Animation::replay()
{
  this->rewind();
  this->bRunning = true;
}
