/*! 
    \file animation_player.h
*/

#ifndef _ANIMATION_PLAYER_H
#define _ANIMATION_PLAYER_H

#include "base_object.h"
#include "animation.h"

/* FORWARD DEFINITION */

//! A AnimationPlayer, that handles the animation of all the Animations in the scene.
/**
   <b>AnimationPlayer usage:</b> \n

   <b>Initialisation</b>: AnimationPlayer::getInstance() does the trick this is 
   usually done when initializing a world \n
   <b>Adding Animations</b>: create an Animation the following Way:
   \li Anim* animation = new Anim(); // also use any other Subclass of Animation to initialize this
   \li set some parameters: also see the specific classes for more info
   \n
   if you do not want a specific Animation to be handled by the AnimationPlayer, you have to 
   unload it explicitely with animation->doNotHandle();
   \n
   eveything else will be done by the AnimationPlayer itself.\n
*/
class AnimationPlayer : public BaseObject {

 public:
  static AnimationPlayer* getInstance(void);
  virtual ~AnimationPlayer(void);

  // animation handling
  void addAnimation(Anim* animation);
  void removeAnimation(Anim* animation);
  void flush(void);

  // time functions
  void tick(float timePassed);
  void play(void);
  void pause(void);

  Anim* getObjectFromBaseObject(const BaseObject* baseObject) const;

  void debug(void);

 private:
  /* singleton */
  AnimationPlayer(void);
  static AnimationPlayer* singletonRef;

  /* class specific */
  tList<Anim>* animationList;              //!< A List of Animations to be handled.
  bool bRunning;                           //!< If the AnimationPlayer is running.
};


#endif /* _ANIMATION_PLAYER_H */
