/*! 
    \file animation_player.h
*/

#ifndef _ANIMATION_PLAYER_H
#define _ANIMATION_PLAYER_H

#include "base_object.h"
#include "animation.h"

/* FORWARD DEFINITION */

//! A AnimationPlayer, that handles the animation of all the Animations in the scene.
class AnimationPlayer : public BaseObject {

 public:
  static AnimationPlayer* getInstance(void);
  virtual ~AnimationPlayer(void);

  void addAnimation(Anim* animation);
  void removeAnimation(Anim* animation);
  void flush(void);

  void tick(float timePassed);

  void debug(void);

 private:
  /* singleton */
  AnimationPlayer(void);
  static AnimationPlayer* singletonRef;

  /* class specific */
  tList<Anim>* animationList;              //!< A List of Animations to be handled
};


#endif /* _ANIMATION_PLAYER_H */
