/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/


#include "animation.h"
#include "debug.h"
#include "animation_player.h"


Anim::Anim(void)
{  
  // initialize a beginning KeyFrame, that will be deleted afterwards
  this->bHasKeys = false;

  // setting default values
  this->localTime = 0.0;
  this->bRunning = true;

  AnimationPlayer::getInstance()->addAnimation(this);
}


Anim::~Anim(void)
{
  AnimationPlayer::getInstance()->removeAnimation(this);
}

void Anim::setInfinity(ANIM_INFINITY postInfinity)
{
  this->postInfinity = postInfinity;
}


void Anim::play()
{
  this->bRunning = true;
}
void Anim::stop()
{
  this->rewind();
  this->bRunning = true;
  this->tick(0.0);
  this->bRunning = false;
}
void Anim::pause()
{
  this->bRunning = false;
}
void Anim::replay()
{
  this->rewind();
  this->bRunning = true;
}
