/*!
  \file stdincl.h
  \brief This file includes default headers that nearly every Class needs.
  
  no Class is defined here, but many headers to classes, and more general Headers like the openGL-header.
*/

#ifndef _STDINCL_H
#define _STDINCL_H

typedef unsigned char byte;

// this includes the information from configure/makefiles
#if HAVE_CONFIG_H 
#include <config.h> 
#endif

#ifdef __WIN32__
#include <windows.h>
#endif

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include "glincl.h"

#include "error.h"
#include "debug.h"


/* performance tweaking stuff */
#ifdef __unix__
 #include <linux/compiler.h>
 #define __LIKELY_IF(condition)  if( likely(condition))
 #define __UNLIKELY_IF(condition) if( unlikely(condition))
#else
 #define __LIKELY_IF(condition)  if( condition)
 #define __UNLIKELY_IF(condition) if( condition)
#endif

#endif /* _STDINCL_H */
