/*! 
    \file weapon.h
    \brief a weapon that a player can use

    A Player has a list of weapons, that can be choosen to shoot projectiles
    (projectiles.{cc,h}) at ennemies. These weapons can be shooted sequentially
    or (if able) combined. Therefore you can choose the weapon mode = choose
    a weapon.

    A weapon is characterized by:
     o firing-rate: the initial firing rate of a weapon (1/s = Herz)
     o slowdown-factor: this is a factor d: exp(-d*x), d is element of all positive R. it determines how fast the firing-rate will slow down. if no slowdown: d=0, the bigger d is, the faster the weapon will slow down!
     o energy-consumption: this determines the energy that has to be used to produce this projectile = costs per projectile
    
    Furthermore there are some other attributes, that will help to represent a firing
    weapon in this world:
     o sound file/ressource: this is a pointer to the sound-file/ressource. however it may be represented
     o shooting animation
     
*/


#ifndef _TEST_GUN_H
#define _TEST_GUN_H

#include "weapon.h"

class Projectile;
class Vector;
class Quaternion;
class SimpleAnimation;


class TestGun : public Weapon
{
  friend class World;

 public:
  TestGun (PNode* parent, Vector* coordinate, Quaternion* direction, int leftRight);
  virtual ~TestGun ();

  virtual void activate(void);
  virtual void deactivate(void);

  virtual void fire(void);
  virtual void hit (WorldEntity* weapon, Vector* loc);
  virtual void destroy(void);
  
  virtual void tick(float time);
  virtual void weaponIdle(void);
  virtual void draw(void);

 private:
  SimpleAnimation* animator;
  Vector* projOffset;
  WorldEntity* dummy1;
  int leftRight;   // this will become an enum

};

#endif /* _TEST_GUN_H */
