

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "test_bullet.h"

#include "world_entity.h"
#include "weapon.h"
#include "null_parent.h"
#include "model.h"
#include "vector.h"

using namespace std;


/**
   \brief standard constructor
*/
TestBullet::TestBullet (Weapon* weapon) : Projectile(weapon)
{
  this->model = (Model*)ResourceManager::getInstance()->load("models/test_projectile.obj", OBJ, RP_LEVEL);
}


/**
   \brief standard deconstructor
*/
TestBullet::~TestBullet () 
{
  /* 
     do not delete the test projectModel, since it is pnode 
     and will be cleaned out by world 
  */
  //delete this->projectileModel;
}



/**
   \brief signal tick, time dependent things will be handled here
   \param time since last tick
*/
void TestBullet::tick (float time) 
{
  Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.1);
  this->shiftCoor(v);

  this->currentLifeTime += time;
  if( this->ttl < this->currentLifeTime)
    {
      PRINTF(5)("FINALIZE==========================\n");
      PRINTF(5)("current life time is: %f/%f\n", this->currentLifeTime, this->ttl);
      PRINTF(5)("FINALIZE===========================\n");
      this->finalize();
      this->currentLifeTime = 0.0f;
    }
}

/**
   \brief the projectile gets hit by another entity
   \param the other entity
   \param place where it is hit
*/
void TestBullet::hit (WorldEntity* entity, Vector* place) 
{}


/**
   \brief the function gets called, when the projectile is destroyed
*/
void TestBullet::destroy () 
{}


void TestBullet::draw () 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];  
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);  
  glScalef(2.0, 2.0, 2.0);
  this->model->draw();

  glPopMatrix();
}

