/*! 
    \file simple_animation.h
    \brief A class to interpolate the movement of an object following descrete points in room and time
    \todo implement it

    This class has been done to animate some movement, works best for short 
    distances.
*/

#ifndef _SIMPLE_ANIMATION_H
#define _SIMPLE_ANIMATION_H

#include "base_object.h"
#include "list.h"


class Vector;
class Quaternion;
class WorldEntity;
class PNode;

typedef enum movementMode{LINEAR=0, EXP, NEG_EXP, SIN, COS, QUADRATIC};
typedef enum animationMode{SINGLE=0, LOOP};
#define DEFAULT_ANIMATION_MODE LINEAR


//! KeyFrame Struct
/**
   This represents one point with direction of the animation
*/
typedef struct KeyFrame {
  Vector* position;
  Quaternion* direction;
  WorldEntity* object;
  float time;
  movementMode mode;
};

//! Animation Struct
/**
   This represents an animation for a object
*/
typedef struct Animation {
  WorldEntity* object;
  KeyFrame* currentFrame;
  KeyFrame* lastFrame;
  Vector* lastPosition;
  Vector* tmpVect;
  tList<KeyFrame>* frames;
  animationMode animMode;
  movementMode movMode;
  bool bRunning;
  float deltaT;
  float localTime;
};

//! Animation Class
/**
   Helps you making some small animation
*/
class SimpleAnimation : public BaseObject {
  
 public:
  static SimpleAnimation* getInstance();

  void animatorBegin();
  void animatorEnd();
  void selectObject(WorldEntity* entity);
  void addKeyFrame(Vector* point, Quaternion* direction, float time);
  void addKeyFrame(Vector* point, Quaternion* direction, float time, movementMode mode);
  void addKeyFrame(KeyFrame* frame);
  void reset();


  void start();
  void stop();
  void restart();
  void pause();
  void resume();

  void tick(float time);

 private:
  SimpleAnimation();
  virtual ~SimpleAnimation();

  static SimpleAnimation* singletonRef;
  bool bDescriptive;               //<! is true, when AnimatorBegin() was executed but no AnimatorEnd() yet: in describtive mode: pass commands
  bool bRunning;                   //<! is set, when the animation is running
  tList<KeyFrame>* frames;         //<! where keyframes are stored in
  tList<Animation>* animators;      //<! a list of animation's
  KeyFrame* currentFrame;          //<! the frame that is been played now
  KeyFrame* lastFrame;
  Vector* lastPosition;
  movementMode mode;               //<! this is an enum of the mode, how the speed is distributed
  float localTime;
  PNode* parent;
  
  Vector* tmpVect;                 //<! this is the temporary vector save place - 
  WorldEntity* workingObject;      //<! this is a pointer to the current working object that has been selected via selectObject()
  Animation* workingAnimator;       //<! the animator with which you are currently working
  float deltaT;                    //<! this is a time constant for the movement

  Animation* getAnimationFromWorldEntity(WorldEntity* entity);

};

#endif /* _SIMPLE_ANIMATION_H */
