/*! 
    \file simple_animation.h
    \brief A class to interpolate the movement of an object following descrete points in room and time
    \todo implement it

    This class has been done to animate some movement, works best for short 
    distances.
*/

#ifndef _SIMPLE_ANIMATION_H
#define _SIMPLE_ANIMATION_H

#include "base_object.h"
#include "list.h"


class Vector;
class Quaternion;
class WorldEntity;
class PNode;

typedef enum movementMode{LINEAR=0, EXP, NEG_EXP, SIN, COS, QUADRATIC};
#define DEFAULT_ANIMATION_MODE LINEAR

//! KeyFrame Struct
/**
   This represents one point with orientation of the animation
*/
typedef struct KeyFrame {
  Vector* position;
  Quaternion* orientation;
  WorldEntity* object;
  float time;
  movementMode mode;
};


//! Animation Class
/**
   Helps you making some small animation
*/
class SimpleAnimation : public BaseObject {
  
 public:
  static SimpleAnimation* getInstance();

  void AnimatorBegin();
  void AnimatorEnd();
  void selectObject(WorldEntity* entity);
  void addKeyFrame(Vector* point, Quaternion* orientation, float time);
  void addKeyFrame(Vector* point, Quaternion* orientation, float time, movementMode mode);
  void addKeyFrame(KeyFrame* frame);
  void reset();


  void start();
  void stop();
  void restart();
  void pause();
  void resume();

  void tick(float time);

 private:
  SimpleAnimation();
  virtual ~SimpleAnimation();

  static SimpleAnimation* singletonRef;
  bool bRunning;                   //<! is set, when the animation is running
  tList<KeyFrame>* frames;         //<! where keyframes are stored in
  KeyFrame* currentFrame;          //<! the frame that is been played now
  KeyFrame* lastFrame;
  movementMode mode;               //<! this is an enum of the mode, how the speed is distributed
  float localTime;
  PNode* parent;
  
  Vector* tmpVect;                 //<! this is the temporary vector save place - 
  WorldEntity* workingObject;      //<! this is a pointer to the current working object that has been selected via selectObject()
  bool bDescriptive;               //<! is true, when AnimatorBegin() was executed but no AnimatorEnd() yet: in describtive mode: pass commands
};

#endif /* _SIMPLE_ANIMATION_H */
