/*! 
    \file graphics_engine.h
    
    \brief defines a Interface between orxonox and graphical input

    handles graphical SDL-initialisation, textures, resolutions, and so on
*/

#ifndef _GRAPHICS_ENGINE_H
#define _GRAPHICS_ENGINE_H

#include "glincl.h"

#include "base_object.h"

// FORWARD DEFINITION \\


class GraphicsEngine : public BaseObject 
{
 public:
  static GraphicsEngine* getInstance();
  virtual ~GraphicsEngine();

  int initVideo();
  int setGLattribs(void);
  int setResolution(int width, int height, int bpp);
  /** \returns the x resolution */
  inline int getResolutionX(void) {return this->resolutionX;}
  /** \returns the y resolution */
  inline int getResolutionY(void) {return this->resolutionY;}
  /** \returns the Bits Per Pixel */
  inline int getbbp(void) {return this->bitsPerPixel;}
  int resolutionChanged(SDL_ResizeEvent* resizeInfo);
  void listModes(void);

  static bool texturesEnabled;

 private:
  GraphicsEngine();
  static GraphicsEngine* singletonRef;


  SDL_Surface* screen;
  int resolutionX;
  int resolutionY;
  int bitsPerPixel;
  bool fullscreen;
  Uint32 videoFlags;

  SDL_Rect **videoModes;
};

#endif /* _GRAPHICS_ENGINE_H */
