

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 


   \todo: direction in which the projectile flights
   \todo: a target to set/hit
*/


#include "test_gun.h"

#include "stdincl.h"
#include "world_entity.h"
#include "model.h"
#include "projectile.h"

#include "vector.h"
#include "list.h"

using namespace std;


/**
   \brief standard constructor

   creates a new weapon
*/
TestGun::TestGun (PNode* parent, Vector* coordinate, Quaternion* direction) 
  :  Weapon (parent, coordinate, direction) 
{
  this->idleTime = 0.2f;
}


/**
   \brief standard deconstructor
*/
TestGun::~TestGun () 
{
  // model will be deleted from WorldEntity-destructor
}


/**
   \brief this activates the weapon

   This is needed, since there can be more than one weapon on a ship. the 
   activation can be connected with an animation. for example the weapon is 
   been armed out. 
*/
void TestGun::activate()
{}


/**
   \brief this deactivates the weapon

   This is needed, since there can be more than one weapon on a ship. the 
   activation can be connected with an animation. for example the weapon is 
   been armed out.
*/
void TestGun::deactivate()
{}


/**
   \brief fires the weapon
   
   this is called from the player.cc, when fire-button is been pushed
*/
void TestGun::fire()
{
  if( this->localTime < this->idleTime)
    {
      this->weaponIdle();
      return;
    }
  Projectile* pj = new Projectile(this);

  pj->setAbsCoor(this->getAbsCoor());
  pj->setAbsDir(this->getAbsDir());

  pj->setFlightDirection(this->getAbsDir());
  pj->setSpeed(this->getSpeed());

  this->worldEntities->add(pj);
  this->localTime = 0;
}


/**
   \brief is called, when the weapon gets hit (=collide with something)
   \param from which entity it is been hit
   \param where it is been hit

   this may not be used, since it would make the game relay complicated when one
   can destroy the weapons of enemies or vice versa.
*/
void TestGun::hit (WorldEntity* entity, Vector* position) 
{}


/**
   \brief is called, when the weapon is destroyed

   this is in conjunction with the hit function, so when a weapon is able to get
   hit, it can also be destoryed.
*/
void TestGun::destroy () 
{}


/**
   \brief tick signal for time dependent/driven stuff
*/
void TestGun::tick (float time) 
{
  this->localTime += time;
  //this->debug();
  //printf("TEST_GUN: this speed is: %f\n", this->getSpeed());
}


/**
   \brief is called, when there is no fire button pressed
*/
void TestGun::weaponIdle()
{}


/**
   \brief this will draw the weapon
*/
void TestGun::draw () 
{}

