

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "projectile.h"

#include "world_entity.h"
#include "weapon.h"
#include "null_parent.h"
#include "model.h"
#include "vector.h"

using namespace std;


/**
   \brief standard constructor
*/
Projectile::Projectile (Weapon* weapon) : WorldEntity()
{
  this->model = (Model*)ResourceManager::getInstance()->load("sphere", PRIM, RP_LEVEL);
  this->weapon = weapon;
  this->flightDirection = NULL;
  this->currentLifeTime = 0.0f;
  this->ttl = 0.75f; /* sec */
  this->speed = 2.0f;
}


/**
   \brief standard deconstructor
*/
Projectile::~Projectile () 
{
  /* 
     do not delete the test projectModel, since it is pnode 
     and will be cleaned out by world 
  */
  //delete this->projectileModel;
}


/**
   \brief this sets the flight direction of the projectile
   \param directin in which to flight

   this function will calculate a vector out of this to be used in the
   tick function
*/
void Projectile::setFlightDirection(Quaternion flightDirection)
{
  if( this->flightDirection == NULL)
    this->flightDirection = new Vector();
  Vector v(1, 0, 0);
  *this->flightDirection = flightDirection.apply(v);
  this->flightDirection->normalize();
}


/**
   \brief this sets the time to life of the projectile
   \param ttl in second

   after this life time, the projectile will garbage collect itself
*/
void Projectile::setTTL(float ttl)
{
  this->ttl = ttl;
}


/**
   \brief sets the speed of the projectile
*/
void Projectile::setSpeed(float speed)
{
  this->speed = speed * 3; /* fix speed settings */
  PRINTF(4)("Projectile::setting speed to: %f\n", this->speed);
}

/**
   \brief signal tick, time dependent things will be handled here
   \param time since last tick
*/
void Projectile::tick (float time) 
{
  Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.7);
  this->shiftCoor(v);

  this->currentLifeTime += time;
  if( this->ttl < this->currentLifeTime)
    {
      PRINTF(5)("FINALIZE==========================\n");
      PRINTF(5)("current life time is: %f/%f\n", this->currentLifeTime, this->ttl);
      PRINTF(5)("FINALIZE===========================\n");
      this->finalize();
      this->currentLifeTime = 0.0f;
    }
}

/**
   \brief the projectile gets hit by another entity
   \param the other entity
   \param place where it is hit
*/
void Projectile::hit (WorldEntity* entity, Vector* place) 
{}


/**
   \brief the function gets called, when the projectile is destroyed
*/
void Projectile::destroy () 
{}


void Projectile::draw () 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];  
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);  
  this->model->draw();

  glPopMatrix();
}

