/*!
    \file shadow.h
    \brief Definition of the Shadow
    
    Shadow should in a first step only be implemented for the players character
    to be casted on the terrain. This version will only handle the players shjadow!
    Further versions will propably be able to take parameters like player or non
    player character and the final object to cast the shadow on to....So it will then
    be possible(maybe) for an object to cast its shadow onto another object(but I think 
    that will be too much performance eating:)
    
    The basic principle to implement the shadow is to create a texture containing 
    a picture of the shadow. This texture then will be mixed onto the normal ground
    texture to give the impression of a shadow correctly casted on the ground.
*/

#ifndef _SHADOW_H
#define _SHADOW_H

#include "importer/material.h"
#include "importer/objModel.h"
#include "p_node.h"
#include "world_entity.h"
#include "player.h"

//! A Class to handle the Shadow
class Shadow: public PNode
{
    private:
	int player_id,ground_id; //These are for the glLists!
	int shadow_id;  //this is for the empty shadow texture
	float lightPos[3];
	float playerPos[3];

	
	unsigned char *image;
	OBJModel* player;
	//playerangle used to obtain information about the angle of the player
	Player* playerangle;
	
	void blur(unsigned char *in,int size);
	void createShadow();
	void m_inverse(const float *m,float *out);
	
    
    public:
	Shadow(OBJModel* player,Player* playerangle,float groundVertexes[]);
	~Shadow();
	void init();
	void draw();
	void updatePosition(float x,float y,float z);




};

#endif
    

