
/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: David Gruetter
   co-programmer: ...


    Created by Dave, this file is actually quite similar to player.cc and so is 
    skybox.h similar to player.h
    With that said, things should be clear:)



*/

#include "importer/material.h"
#include "skysphere.h"
#include "stdincl.h"
#include "vector.h"
#include "world_entity.h"


using namespace std;

/**
   \brief Standart Constructor
   \todo second Constructor with char* input for different skies
*/
Skysphere::Skysphere()
{  
    //GLUquadricObj *sphereObj=0;
    sphereObj=gluNewQuadric();
    gluQuadricTexture(sphereObj,GL_TRUE);
    sky = new Material("Sky");
    sky->setDiffuseMap("../data/pictures/sky-replace.jpg");
    sky->setIllum(3);
    //    sky->setAmbient(1,1,1);

}

/**
   \brief default destructor
*/
Skysphere::~Skysphere()
{
    delete sky;
    delete sphereObj;

}

/**
   \brief updates the position of the Skysphere
   \param x the x-coordinate of the Center of the Sphere
   \param y the y-coordinate of the Center of the Sphere
   \param z the z-coordinate of the Center of the Sphere

   This is normally done in the update-phase of world, so the Skysphere is always centered at the Camera.
*/
void Skysphere::updatePosition(float x,float y,float z)
{
    this->a=x;
    this->b=y;
    this->c=z;
}

/**
   \brief draws the Skysphere

   This part is normally precessed in the "Painting Phase".
*/
   
void Skysphere::draw()
{
    glEnable(GL_COLOR_MATERIAL);
    sky->select();
    glPushMatrix();
    glTranslatef(this->a,this->b,this->c);
    
    glRotatef(-30,1,0,0);
    glRotatef(95.0f,0.0f,0.0f,1.0f);
    glRotatef(-250.0f,0.0,1.0f,0.0f);
    
    gluSphere(sphereObj,200.0f,20,20);
    glPopMatrix();
    glDisable(GL_COLOR_MATERIAL);


}


