/*! 
    \file world.h
    \brief Holds and manages all game data
*/ 

#ifndef _WORLD_H
#define _WORLD_H


#include "stdincl.h"
#include "story_entity.h"
#include "skysphere.h"
class Material;


class TrackManager;
class Track;
class WorldEntity;
class Camera;
class PNode;
class GLMenuImageScreen;

//! The game environment
class World : public StoryEntity {

 public:
  World (char* name);
  World (int worldID);
  virtual ~World ();
  
  virtual ErrorMessage init ();
  virtual ErrorMessage start ();
  virtual ErrorMessage stop ();
  virtual ErrorMessage pause ();
  virtual ErrorMessage resume ();

  virtual void load ();
  virtual void destroy ();

  //static void vertexCallback (GLfloat* vertex);

  void timeSlice (Uint32 deltaT);
  void collide ();
  void draw ();
  void update ();	// maps Locations to Placements
  //void calcCameraPos (Location* loc, Placement* plc);
	
  void unload ();
  bool command (Command* cmd);
  virtual void displayLoadScreen();
  virtual void releaseLoadScreen();
  
  void setTrackLen (Uint32 tracklen);
  int getTrackLen ();
  //bool system_command (Command* cmd);
  Camera* getCamera ();

  void spawn (WorldEntity* entity);
  void spawn (WorldEntity* entity, Vector* absCoor, Quaternion* absDir);

  tList<WorldEntity>* entities;
  
  
  // base level data
  
  TrackManager* trackManager;
  Track* track;
  Uint32 tracklen;   // number of Tracks the World consist of
  Vector* pathnodes;
  Camera* localCamera;  


  UPointCurve* testCurve;
 private:
  Uint32 lastFrame; //!> last time of frame
  bool bQuitOrxonox; //!> quit this application
  bool bQuitCurrentGame; //!> quit only the current game and return to menu
  bool bPause;

  GLMenuImageScreen* glmis;

  char* worldName;
  int debugWorldNr;
  GLuint objectList;
  SDL_Surface *loadImage;

  WorldEntity* localPlayer;
  Skysphere* skysphere;
  PNode* nullParent;
 
  void mainLoop ();
  void synchronize ();
  void handleInput ();
  void timeSlice ();
  void collision ();
  void display ();
  void debug ();

  void swap (unsigned char &a, unsigned char &b); /* \todo: this function doesn't belong here, this should be part of a image class*/
};

#endif /* _WORLD_H */
