/*! 
    \file player.h
    \brief Implements a basic controllable WorldEntity
*/

#ifndef _PLAYER_H
#define _PLAYER_H

#include "world_entity.h"

class OBJModel;

//! Basic controllable WorldEntity
class Player : public WorldEntity 
{
  friend class World;
  
 public:
  Player(bool isFree = false);
  ~Player();
  
  virtual void postSpawn();
  virtual void tick(float time);
  virtual void hit(WorldEntity* weapon, Vector loc);
  virtual void destroy();
  virtual void collide(WorldEntity* other, Uint32 ownhitflags, Uint32 otherhitflags);
  virtual void command(Command* cmd);
  
  virtual void draw();
  // virtual void getLookat(Location* locbuf);
  
  virtual void leftWorld();
  
  
 private:
  bool bUp, bDown, bLeft, bRight, bAscend, bDescend;
  bool bFire;
  
  Vector velocity;
  Vector accelSlip;
  Vector accelSlipDirection;
  float travelSpeed;
  float acceleration;
  float angle;
  GLuint objectList;
  
  void move(float time);
  void rotate(float time);
  void backRotate(float time);
  Vector slip (float time,Vector accel);
};

#endif /* _PLAYER_H */
