

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
*/

#include "player.h"
#include "stdincl.h"
#include "collision.h"
#include "importer/objModel.h"

using namespace std;


Player::Player(bool isFree) : WorldEntity(isFree)
{

  this->model = new OBJModel("../data/models/reaplow.obj");
  /*
  objectList = glGenLists(1);
  glNewList (objectList, GL_COMPILE);

  glBegin(GL_TRIANGLES);
  glColor3f(1,1,1);
  glVertex3f(0,0,0.5);
  glVertex3f(-0.5,0,-1);
  glVertex3f(0.5,0,-1);

  glVertex3f(0,0,0.5);
  glVertex3f(0,0.5,-1);
  glVertex3f(0,-0.5,-1);
  glEnd();
    
  glBegin(GL_QUADS);
  glColor3f(0,0,1);
  glVertex3f(0.5,0.5,-1);
  glVertex3f(0.5,-0.5,-1);
  glVertex3f(-0.5,-0.5,-1);
  glVertex3f(-0.5,0.5,-1);
  glEnd();
  
  glEndList ();
  */
}

Player::~Player ()
{
  delete this->model;
}

void Player::postSpawn ()
{
  travelSpeed = 15.0;
  velocity = Vector();
  bUp = bDown = bLeft = bRight = bAscend = bDescend = false;
  bFire = false;
  acceleration = 20.0;
  setCollision(new CollisionCluster(1.0, Vector(0,0,0)));
}

void Player::tick (float time)
{
  // movement
  this->move (time);
}

void Player::hit (WorldEntity* weapon, Vector loc)
{
}

void Player::destroy ()
{
}

void Player::collide (WorldEntity* other, Uint32 ownhitflags, Uint32 otherhitflags)
{
}

void Player::command (Command* cmd)
{
  //printf("Player|recieved command [%s]\n", cmd->cmd);
  if( !strcmp( cmd->cmd, "up")) bUp = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "down")) bDown = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "left")) bLeft = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "right")) bRight = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "fire")) bFire = !cmd->bUp;
}

void Player::draw ()
{ 
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  float matrix[4][4];
  //glRotatef(90.0f,1.0f,0.0f,0.0f); 
  /* translate */
  glTranslatef (this->getAbsCoor ().x, 
		this->getAbsCoor ().y, 
		this->getAbsCoor ().z);
  /* rotate */
  this->getAbsDir ().matrix (matrix);
  glMultMatrixf((float*)matrix);
  glRotatef(angle,1.0f,0.0f,0.0f);
  glMatrixMode(GL_MODELVIEW);
  this->model->draw();
  // glCallList(objectList);
}


/*PN
void Player::getLookat(Location* locbuf)
{
  *locbuf = *getLocation();
  //locbuf->dist += 5.0;
}
*/

void Player::leftWorld ()
{
}

void Player::move (float time)
{
 
  Vector accel(0.0, 0.0, 0.0);
  
  /* FIXME: calculating the direction and orthDirection every timeSlice is redundant! save it somewhere */
  //Placement *pos = getPlacement();
  
  /* calculate the direction in which the craft is heading  */
  Vector direction (1.0, 0.0, 0.0);
    
  
  
  //direction = this->absDirection.apply (direction);
  Vector orthDirection (0.0, 0.0, 1.0);
  
  //orthDirection = orthDirection.cross (direction);

  if( bUp) { accel = accel+(direction*acceleration);accelSlipDirection=accel; }
  if( bDown) { accel = accel-(direction*acceleration);accelSlipDirection=accel; }
  if( bLeft ) {if(angle<0) {accel = accel-(orthDirection*acceleration);}rotate(time);accelSlip=accel; }
  if( bRight ) { if(angle>0){accel = accel+(orthDirection*acceleration);}rotate(time);accelSlip=accel;}
  if( bAscend ) { /* not yet implemented but just: (0,0,1)*acceleration */}
  if( bDescend) {/* FIXME */} /* \todo up and down player movement */
  if((int)angle!=0&&!bLeft&&!bRight){backRotate(time);accelSlip=accelSlip-slip(time,accelSlip);}
  if(!bUp&&!bDown){accelSlipDirection=accelSlipDirection-slip(time,accelSlipDirection);}

  //Location* l = getLocation();
  
  // r(t) = r(0) + v(0)*t + 1/2*a*t^2
  // r = position
  // v = velocity
  // a = acceleration

  /* this the base-speed of the player: determines how fast and how the player follows the track*/
  //l->dist = l->dist + travelSpeed * time;
  
  //Vector* shift = new Vector (this->travelSpeed * time, 0, 0);
  Vector shift(this->travelSpeed*time,0,0);
  
  this->shiftCoor (&shift);
  
  /* this updates the player position on the track - user interaction */
  //l->pos = l->pos + accel*time;
  
  Vector move = accel * time;
  this->shiftCoor (&move);
  
}
void Player::rotate(float time){
    if(bLeft&&angle>-40.0f){
	angle=angle-time*200.0f;
		
    }
    if(bRight&&angle<40.0f){
        angle=angle+time*200.0f;
		
    }
}

void Player::backRotate(float time){
    if(angle<0){
    angle=angle+3.0f*(exp(angle*.0015f*time));
    
    
    }
    if(angle>0){
    angle=angle-3.0f*(exp(-angle*.0015f*time));
    
    
    }

}
//When the sidewords movement is finished, the ship will still slip untill it stands still
Vector Player::slip(float time,Vector accel){
	Vector move= accel*time;
	this->shiftCoor(&move);
	return accel*time*3.0f;
    
}





