/*! 
    \file glfont.h
    \brief Handles the display of glFonts.
*/

#ifndef _GLFONT_H
#define _GLFONT_H

#include "glincl.h"
#include "SDL_ttf.h"


/* some default values */
#define FONT_DEFAULT_SIZE       18
#define FONT_DEFAULT_TEXT	"orxonox 1234567890"
#define FONT_DEFAULT_COLOR_R    256
#define FONT_DEFAULT_COLOR_G    256
#define FONT_DEFAULT_COLOR_B    256
#define FONT_NUM_COLORS         256



//! A struct for handling glyphs
struct glyph
{
  Uint16 character;
  int minX;
  int maxX;
  int minY;
  int maxY;
  int width;
  int height;
  int bearingX;
  int bearingY;
  int advance;
};


class GLFont
{
 public:
  GLFont(const char* fontFile, unsigned int fontSize = FONT_DEFAULT_SIZE);
  virtual ~GLFont();

  static void enableFonts(void);
  static void disableFonts(void);

  bool setFont(const char* fontFile);
  void setText(const char* text);

  void setStyle(char* renderStyle);
  void setSize(unsigned int fontSize);
  void setColor(Uint8 r, Uint8 g, Uint8 b);
  void setPosition(int x, int y);

  void createTexture(void);
  
  void renderText(void);
  void renderText(const char* text, int x, int y);

  virtual void draw(void);

 private:
  // information about the Font
  TTF_Font* font;
  char* fontFile;
  char* text;
  unsigned int fontSize;
  SDL_Color color;

  // placement in openGL
  GLuint texture;
  int positionX;
  int positionY;
  int renderStyle;
  SDL_Surface* surface;
  GLfloat* texcoord;

  bool init(const char* fontFile, unsigned int fontSize = FONT_DEFAULT_SIZE);
  int getMaxHeight(void);
  int getMaxAscent(void);
  int getMaxDescent(void);
  glyph getGlyphMetrics(Uint16 character);

  static bool ttfInitialized;

  void enter2DMode(void);
  void leave2DMode(void);

  static bool checkVersion(void);

  GLuint loadTexture(SDL_Surface* surface, GLfloat* texcoord);

  static int powerOfTwo(int input);

  void debug(void);

};

#endif /* _GLFONT_H */
