

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 


   \todo: direction in which the projectile flights
   \todo: a target to set/hit
*/


#include "test_gun.h"

#include "stdincl.h"
#include "world_entity.h"
#include "model.h"
#include "projectile.h"

#include "vector.h"
#include "list.h"

using namespace std;


/**
   \brief standard constructor

   creates a new weapon
*/
TestGun::TestGun (PNode* parent, Vector* coordinate, Quaternion* direction) 
  :  Weapon (parent, coordinate, direction) 
{}


/**
   \brief standard deconstructor
*/
TestGun::~TestGun () 
{
  // model will be deleted from WorldEntity-destructor
}


/**
   \brief this activates the weapon

   This is needed, since there can be more than one weapon on a ship. the 
   activation can be connected with an animation. for example the weapon is 
   been armed out. 
*/
void TestGun::activate()
{}


/**
   \brief this deactivates the weapon

   This is needed, since there can be more than one weapon on a ship. the 
   activation can be connected with an animation. for example the weapon is 
   been armed out.
*/
void TestGun::deactivate()
{}


/**
   \brief fires the weapon
   
   this is called from the player.cc, when fire-button is been pushed
*/
void TestGun::fire()
{
  //printf("TestGun::fire() - firing weapon now ---------------------------\n");
  Projectile* pj = new Projectile();

  Vector* v = new Vector();
  *v = this->getAbsCoor();
  pj->setAbsCoor(v);
  Quaternion* q = new Quaternion();
  *q = this->getAbsDir();
  pj->setAbsDir(q);

  pj->setFlightDirection(q);
  //pj->setSpeed(this->getSpeed() * 0.025);



  this->worldEntities->add(pj);
}


/**
   \brief is called, when the weapon gets hit (=collide with something)
   \param from which entity it is been hit
   \param where it is been hit

   this may not be used, since it would make the game relay complicated when one
   can destroy the weapons of enemies or vice versa.
*/
void TestGun::hit (WorldEntity* entity, Vector* position) 
{}


/**
   \brief is called, when the weapon is destroyed

   this is in conjunction with the hit function, so when a weapon is able to get
   hit, it can also be destoryed.
*/
void TestGun::destroy () 
{}


/**
   \brief tick signal for time dependent/driven stuff
*/
void TestGun::tick (float time) 
{}


/**
   \brief is called, when there is no fire button pressed
*/
void TestGun::weaponIdle()
{}


/**
   \brief this will draw the weapon
*/
void TestGun::draw () 
{}

