

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "glmenu_imagescreen.h"

#include "stdincl.h"
#include "material.h"

using namespace std;

GLMenuImageScreen* GLMenuImageScreen::singletonRef = 0;

GLMenuImageScreen* GLMenuImageScreen::getInstance()
{
  if(!singletonRef)
    singletonRef = new GLMenuImageScreen ();
  return singletonRef;
}

/**
   \brief standard constructor

   \todo this constructor is not jet implemented - do it
*/
GLMenuImageScreen::GLMenuImageScreen () 
{
   this->setClassName ("GLMenuImageScreen");
   this->backMat = NULL;
}


/**
   \brief standard deconstructor
   \todo this deconstructor is not jet implemented - do it
*/
GLMenuImageScreen::~GLMenuImageScreen() 
{
  if (this->backMat)
    delete this->backMat;
}

/**
   \brief function to init the screen
*/
void GLMenuImageScreen::init ()
{
  /*
  int w = 680;
  int h = 480;

  glViewport(0,0,w,h);
  
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity(); 
  gluPerspective(45.0f,(GLfloat)w/(GLfloat)h, .5f ,150.0f);
  glMatrixMode(GL_MODELVIEW); 

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();
  gluLookAt(0, 0, 6,     0, 0, 0,     0, 1, 0);

  // Bind the texture stored at the zero index of g_Texture[]
  //glBindTexture(GL_TEXTURE_2D, g_Texture[0]);
  */

  
  // Select Our VU Meter Background Texture
  this->backMat = new Material("load_screen");
  this->backMat->setDiffuseMap("pictures/load_screen.jpg");
  this->maxValue = 10;
  this->currentValue = 0;

  // End of Background image code.
}


/**
   \brief function to innit screen with all attributes set
   \param name of the background-image file
   \param height of the ImageScreen
   \param width of the Image Screen
   \param x offset from (0, 0)
   \param y offset from (0, 0)

   GLMenu uses its own coordinating system: upper left corner is (0, 0). x-axis is down=height, 
   right axis is right direction (=width)
*/
void GLMenuImageScreen::init (char* backImageName, float height, float width, 
			      float offsetX, float offsetY)
{}


/**
   \brief draws the ImageScreen to the screenbuffer
*/
void GLMenuImageScreen::draw ()
{

  glClear( GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);


  //PRINTF()();
  printf("GLMenuImagEscreen::draw() - drawing step %i/%i\n", 
	 this->currentValue, this->maxValue);

  /* screen size */
  int screenWidth = 640;
  int screenHeight = 480;
  
  /* set image size */
  int imageWidth = 640;
  int imageHeight = 480;
  
  /* start pos of image */
  int offsetX = (screenWidth - imageWidth)/2;
  int offsetY = (screenHeight - imageHeight)/2;
  
  /* loadbar pos */
  int barX = 390;
  int barY = 50;
  int barWidth = 230;
  int barHeight = 30;
  
  float val = ((float)this->currentValue/(float)this->maxValue) * barWidth;
  if( val > (float)barWidth)
    val = (float)barWidth;

  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  /* set up an ortho screen */
  glOrtho(0, screenWidth, 0, screenHeight, -1, 1); 
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  glPushMatrix();

  glEnable(GL_BLEND);
  glPushAttrib(GL_LIGHTING_BIT | GL_TRANSFORM_BIT);
  glDisable(GL_LIGHTING);

  /* draw the progress bar */
  glBegin(GL_QUADS);
  glColor3f(0.96, 0.84, 0.34);
  glVertex2i(barX, barY);
  glVertex2i(barX + (int)val, barY);
  glVertex2i(barX + (int)val, barY + barHeight);
  glVertex2i(barX, barY + barHeight);
  glColor3f(1.0, 1.0, 1.0);
  glEnd();

  glBegin(GL_QUADS);
  glColor3f(0.0, 0.0, 0.0);
  glVertex2i(barX, barY);
  glVertex2i(barX + barWidth, barY);
  glVertex2i(barX + barWidth, barY + barHeight);
  glVertex2i(barX, barY + barHeight);
  glColor3f(1.0, 1.0, 1.0);
  glEnd();

  /* draw black border */
  glBegin(GL_QUADS);
  glColor3f(0.0, 0.0, 0.0);
  glVertex2i(barX-1, barY-1);
  glVertex2i(barX + barWidth +1, barY-1);
  glVertex2i(barX + barWidth+1, barY + barHeight+1);
  glVertex2i(barX - 1, barY + barHeight +1);
  glColor3f(1.0, 1.0, 1.0);
  glEnd();

  /* draw white border */
  glBegin(GL_QUADS);
  glColor3f(1.0, 1.0, 1.0);
  glVertex2i(barX-2, barY-2);
  glVertex2i(barX + barWidth +2, barY-2);
  glVertex2i(barX + barWidth+2, barY + barHeight+2);
  glVertex2i(barX - 2, barY + barHeight +2);
  glColor3f(1.0, 1.0, 1.0);
  glEnd();

  backMat->select();
  glBegin(GL_QUADS);
  glTexCoord2i(0, 0); glVertex2i(offsetX, offsetY);
  glTexCoord2i(1, 0); glVertex2i(offsetX + imageWidth, offsetY);
  glTexCoord2i(1, 1); glVertex2i(offsetX + imageWidth, offsetY + imageHeight);
  glTexCoord2i(0, 1); glVertex2i(offsetX, offsetY + imageHeight);
  glEnd();
  glDisable(GL_TEXTURE_2D);

  glDisable(GL_BLEND);
  glPopMatrix();
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();
  glPopAttrib();

  SDL_GL_SwapBuffers();              
}
 

/** 
    \brief sets the background image name
    \param file name of the backgroun-image
 */
void GLMenuImageScreen::setBackImageName (char* backImageName)
{}


/**
   \brief sets position of the ImageScreen
   \param x offset from (0, 0)
   \param y offset from (0, 0)
*/
void GLMenuImageScreen::setPosition(float offsetX, float offsetY)
{}


/*
  \brief sets size of the ImageScreen
  \param height of the ImageScreen
  \param width of the Image Screen
*/
void GLMenuImageScreen::setSize(float height, float width)
{}


/**
   \brief set the maximum of countable steps
   \param maximum of steps
*/
void GLMenuImageScreen::setMaximum(int maxValue)
{
  this->maxValue = maxValue;
}


/**
   \brief gets the maximum of countable steps
*/
int GLMenuImageScreen::getMaximum()
{
  return this->maxValue;
}


/**
   \brief set current value
   \param current value
*/
void GLMenuImageScreen::setValue(int currentValue)
{
  this->currentValue = currentValue;
  this->draw();
}


/**
   \brief get the current value
 */
int GLMenuImageScreen::getValue()
{
  return this->currentValue;
}


/** 
    \brief call this to trigger a progress event
    
    this has to redraw the progress bar and the whole image
 */
void GLMenuImageScreen::step ()
{
  this->currentValue++;
  this->draw();
}
