

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "projectile.h"

#include "world_entity.h"
#include "null_parent.h"
#include "objModel.h"
#include "primitive.h"
#include "vector.h"

using namespace std;


/**
   \brief standard constructor
*/
Projectile::Projectile () : WorldEntity()
{
  this->model = (Model*)ResourceManager::getInstance()->load("sphere", PRIM, RP_LEVEL);
  this->flightDirection = NULL;
  this->currentLifeTime = 0.0f;
  this->ttl = 1.0f;
  this->speed = 2.0f;
}


/**
   \brief standard deconstructor
*/
Projectile::~Projectile () 
{
  /* 
     do not delete the test projectModel, since it is pnode 
     and will be cleaned out by world 
  */
  //delete this->projectileModel;
}


/**
   \brief this sets the flight direction of the projectile
   \param directin in which to flight

   this function will calculate a vector out of this to be used in the
   tick function
*/
void Projectile::setFlightDirection(Quaternion* flightDirection)
{
  if( this->flightDirection == NULL)
    this->flightDirection = new Vector();
  Vector v(1, 0, 0);
  *this->flightDirection = flightDirection->apply(v);
}


/**
   \brief this sets the time to life of the projectile
   \param ttl in second

   after this life time, the projectile will garbage collect itself
*/
void Projectile::setTTL(float ttl)
{
  this->ttl = ttl;
}


/**
   \brief sets the speed of the projectile
*/
void Projectile::setSpeed(float speed)
{
  this->speed = speed;
  printf("Projectile::setting speed to: %f\n", this->speed);
}

/**
   \brief signal tick, time dependent things will be handled here
   \param time since last tick
*/
void Projectile::tick (float time) 
{
  this->currentLifeTime += time;
  if( this->ttl < this->currentLifeTime)
    {
      *this->flightDirection = *this->flightDirection * this->speed * time;
      this->shiftCoor(this->flightDirection);
      this->flightDirection->debug();
      return;
    }
  this->finalize();
  //NullParent* np = NullParent::getInstance();
  /* garbage colelction */
  // \fix: there is no gc in this class, its all been done by GarbageCollector
}

/**
   \brief the projectile gets hit by another entity
   \param the other entity
   \param place where it is hit
*/
void Projectile::hit (WorldEntity* entity, Vector* place) 
{}


/**
   \brief the function gets called, when the projectile is destroyed
*/
void Projectile::destroy () 
{}


void Projectile::draw () 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];  
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);  
  this->model->draw();

  glPopMatrix();
}

