

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD

#include "garbage_collector.h"

#include "world.h"
#include "world_entity.h"
#include "null_parent.h"

#include "list.h"

using namespace std;


GarbageCollector* GarbageCollector::singletonRef = 0;

/**
   \brief standard constructor
   \todo this constructor is not jet implemented - do it
*/
GarbageCollector::GarbageCollector () 
{
   this->setClassName ("GarbageCollection");
   this->time = 0;
   this->delay = 3.0f; /* clean up all 5.0 seconds */
}


/**
   \brief standard deconstructor

*/
GarbageCollector::~GarbageCollector () 
{
  // delete what has to be deleted here
}


/**
   \brief this returns the singleton reference this this class
   \returns singleton reference
*/
GarbageCollector* GarbageCollector::getInstance()
{
  if( singletonRef == NULL)
    singletonRef = new GarbageCollector();
  return singletonRef;
}


/**
   \brief this sets the collection delay
   \param delay
   
   after this delay, the garbage collector starts its work and begins to collect unused object
   to delete them afterwards. only objects in the worldentity list from the world object are lookded
   at. 
*/
void GarbageCollector::setCollectionDelay(float delay)
{
  this->delay = delay;
}


/**
   \brief this foreces a garbage collection

   if this function is called, the gc tries to initiate the garbage collection routines. actually
   this should always work.
*/
void GarbageCollector::forceCollection()
{
  /* just make the time slitely bigger than the delay */
  this->time = this->delay + 1;
  /* and update, to get rid of the unused objects */
  this->update();
}


/**
   \brief this ticks the GarbageCollector to give it the time pulse
   \param the time passed since last tick

   like every other tick function eg. worldentity
*/
void GarbageCollector::tick(float time)
{
  this->time += time;
}


/**
   \brief this updated the gargabe collection, if the time is ready


*/
void GarbageCollector::update()
{
  if( this->time < this->delay)
    return;
  /* garbage collect */
  PRINTF(3)("GarbageCollection is been done\n");
  WorldInterface* wi = WorldInterface::getInstance();
  tList<WorldEntity>* list = wi->getEntityList();

  tIterator<WorldEntity>* iterator = list->getIterator();
  WorldEntity* entity = iterator->nextElement();
  while( entity != NULL) 
    { 
      if( entity->isFinalized())
	{
	  PRINTF(1)("Finalizing object in list - not yet done realy\n");
	  
	  /* first remove out of entity list */
	  list->remove(entity);
	  /* second remove out of pnode tree */
	  //entity->remove();
	  //delete entity;
	}
      entity = iterator->nextElement();
    }
  
  /* reset time to count again up to this->delay */
  this->time = 0;
}
