

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_PLAYER

#include "player.h"

#include "track_manager.h"
#include "objModel.h"
#include "resource_manager.h"
#include "weapon.h"
#include "test_gun.h"
#include "world.h"

#include "list.h"
#include "stdincl.h"

using namespace std;

/**
   \brief creates a new Player
   \param isFree if the player is free
*/
Player::Player() : WorldEntity()
{
  this->weapons = new tList<Weapon>();
  this->activeWeapon = NULL;
  /*
    this is the debug player - actualy we would have to make a new
     class derivated from Player for each player. for now, we just use
     the player.cc for debug also
  */
  this->model = (Model*)ResourceManager::load("models/reaplow.obj", OBJ, RP_CAMPAIGN);
  travelSpeed = 15.0;
  velocity = new Vector();
  bUp = bDown = bLeft = bRight = bAscend = bDescend = false;
  bFire = false;
  acceleration = 10.0;
  //weapons:
  Weapon* wp = new TestGun(this, new Vector(), new Quaternion);
  this->weapons->add(wp);
  this->activeWeapon = wp;  
}

/**
   \brief destructs the player, deletes alocated memory
*/
Player::~Player ()
{
  /* do not delete the weapons, they are contained in the pnode tree
     and will be deleted there.
     this only frees the memory allocated to save the list.
  */
  delete this->weapons;
}


/**
   \brief adds a weapon to the weapon list of player
   \param weapon to add
*/
void Player::addWeapon(Weapon* weapon)
{
  this->weapons->add(weapon);
}


/**
   \brief removes a weapon from the player
   \param weapon to remove
*/
void Player::removeWeapon(Weapon* weapon)
{
  this->weapons->remove(weapon);
}


/**
   \brief effect that occurs after the player is spawned
*/
void Player::postSpawn ()
{
  //setCollision(new CollisionCluster(1.0, Vector(0,0,0)));
}


/**
   \brief the action occuring if the player left the game
*/
void Player::leftWorld ()
{}



/**
   \brief if the player is hit, call this function
   \param weapon hit by this weapon
   \param loc ??
*/
void Player::hit (WorldEntity* weapon, Vector* loc)
{
}


/** 
    \brief Collision with another Entity has this effect
    \param other the other colider
    \param ownhitflags ??
    \param otherhitflags ??
*/
void Player::collide (WorldEntity* other, Uint32 ownhitflags, Uint32 otherhitflags)
{
}


/**
   \brief draws the player after transforming him.
*/
void Player::draw ()
{ 
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];
  
  /* translate */
  glTranslatef (this->getAbsCoor ().x, 
		this->getAbsCoor ().y, 
		this->getAbsCoor ().z);
  /* rotate */
  this->getAbsDir ().matrix (matrix);
  glMultMatrixf((float*)matrix);
  
  this->model->draw();
  glPopMatrix();
}


/**
   \brief the function called for each passing timeSnap
   \param time The timespan passed since last update
*/
void Player::tick (float time)
{
  // player controlled movement
  this->move(time);
  // weapon system manipulation
  this->weapon();
}


/**
   \brief action if player moves
   \param time the timeslice since the last frame
*/
void Player::move (float time)
{
  Vector accel(0.0, 0.0, 0.0);
  /* FIXME: calculating the direction and orthDirection every timeSlice is redundant! save it somewhere */
  
  /* calculate the direction in which the craft is heading  */
  Vector direction (1.0, 0.0, 0.0);
  //direction = this->absDirection.apply (direction);
  Vector orthDirection (0.0, 0.0, 1.0);
  //orthDirection = orthDirection.cross (direction);

  if( this->bUp && this->getRelCoor().x < 20)
    accel = accel+(direction*acceleration);
  if( this->bDown && this->getRelCoor().x > -5)
    accel = accel-(direction*acceleration);
  if( this->bLeft &&  TrackManager::getInstance()->getWidth() > -this->getRelCoor().z*2)
    accel = accel - (orthDirection*acceleration); 
  if( this->bRight &&  TrackManager::getInstance()->getWidth() > this->getRelCoor().z*2)
    accel = accel + (orthDirection*acceleration);
  if( this->bAscend )
  if( this->bDescend) {/* FIXME */} /* \todo up and down player movement */

  Vector move = accel * time;
  this->shiftCoor (&move);
}


/**
   \brief weapon manipulation by the player
*/
void Player::weapon()
{
  if( this->bFire)
    {
      if(this->activeWeapon != NULL)
	this->activeWeapon->fire();
    }
  if( this->bWeaponChange && this->weapons->getSize() > 1)
    {
      PRINTF(1)("changing the weapon of the player: deactivate old, activate new\n");
      this->activeWeapon->deactivate();
      //this->weapons->enumerate();  FIX: strang weapon change...
      this->activeWeapon = this->weapons->nextElement(this->activeWeapon);
      this->activeWeapon->activate();
    }
}


/**
   \brief The connection to the command node
   \param cmd the Command unit from witch to map

   here the commands are mapped to the players movement/weaponary
*/
void Player::command (Command* cmd)
{
  PRINTF(3)("recieved command [%s]\n", cmd->cmd);
  if( !strcmp( cmd->cmd, "up")) this->bUp = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "down")) this->bDown = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "left")) this->bLeft = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "right")) this->bRight = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "fire")) this->bFire = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "mode")) this->bWeaponChange = !cmd->bUp;
}
